/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;

public class SlushFluidType
extends FluidType {
    public SlushFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public double motionScale(Entity entity) {
        return 0.00235;
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        entity.setDeltaMovement(vec3.x * (double)0.95f, vec3.y + (double)(vec3.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3.z * (double)0.95f);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(this){
            private static final ResourceLocation SLUSH_STILL = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"block/slush_still");
            private static final ResourceLocation SLUSH_FLOW = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"block/slush_flow");

            public ResourceLocation getStillTexture() {
                return SLUSH_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return SLUSH_FLOW;
            }

            public int getTintColor() {
                return FastColor.ARGB32.color((int)240, (int)210, (int)240, (int)255);
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                int color = BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter, (BlockPos)pos);
                int red = FastColor.ARGB32.red((int)color);
                int green = FastColor.ARGB32.green((int)color);
                int blue = FastColor.ARGB32.blue((int)color);
                int alphaColor = FastColor.ARGB32.color((int)240, (int)red, (int)green, (int)blue);
                int white = FastColor.ARGB32.color((int)240, (int)240, (int)255, (int)255);
                return CSMath.blendColors(alphaColor, white, 0.5f);
            }
        });
    }
}

