/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.api.util.placement.Matcher;
import com.momosoftworks.coldsweat.api.util.placement.Mode;
import com.momosoftworks.coldsweat.api.util.placement.Order;
import com.momosoftworks.coldsweat.api.util.placement.Placement;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import dev.ghen.thirst.content.registry.ThirstComponent;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class FilledWaterskinItem
extends Item {
    public static final double EFFECT_RATE = 0.5;
    private static final DispenseItemBehavior DISPENSE_BEHAVIOR = (source, stack) -> {
        final BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        ServerLevel level = source.level();
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, pos);
        double itemTemp = (Double)stack.getOrDefault(ModItemComponents.WATER_TEMPERATURE, (Object)0.0);
        if (chunk == null) {
            return stack;
        }
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.WATERSKIN_POUR, SoundSource.BLOCKS, 1.0f, (float)(Math.random() / 5.0 + 0.9));
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleServer(() -> FilledWaterskinItem.lambda$static$2(rand, pos, (Level)level), i);
        }
        new Object((Level)level, itemTemp, chunk){
            double acceleration = 0.0;
            int tick = 0;
            AABB aabb = new AABB(pos).inflate(0.5);
            Set<Player> affectedPlayers = new HashSet<Player>();
            final /* synthetic */ Level val$level;
            final /* synthetic */ double val$itemTemp;
            final /* synthetic */ ChunkAccess val$chunk;
            {
                this.val$level = level;
                this.val$itemTemp = d;
                this.val$chunk = chunkAccess;
            }

            void start() {
                NeoForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void onTick(LevelTickEvent.Pre event) {
                if (event.getLevel().isClientSide() == this.val$level.isClientSide()) {
                    double waterTemp = CSMath.blend(this.val$itemTemp, this.val$itemTemp / 5.0, (double)this.tick, 20.0, 100.0);
                    double effectAmount = waterTemp * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
                    double wetnessTemp = 0.05 * (double)CSMath.sign(waterTemp + 0.01);
                    this.aabb = this.aabb.move(0.0, -this.acceleration, 0.0);
                    BlockPos pos2 = BlockPos.containing((double)this.aabb.minX, (double)this.aabb.minY, (double)this.aabb.minZ);
                    if (WorldHelper.isFullSide(this.val$chunk.getBlockState(pos2).getShape((BlockGetter)this.val$level, pos2), Direction.UP)) {
                        NeoForge.EVENT_BUS.unregister((Object)this);
                        return;
                    }
                    this.val$level.getEntitiesOfClass(Player.class, this.aabb).forEach(player -> {
                        if (!this.affectedPlayers.contains(player)) {
                            Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(effectAmount).expires(0), Temperature.Trait.CORE, Placement.LAST);
                            Temperature.replaceOrAddModifier((LivingEntity)player, new WaterTempModifier(wetnessTemp).tickRate(5), Temperature.Trait.WORLD, Matcher.SAME_CLASS);
                            this.affectedPlayers.add((Player)player);
                        }
                    });
                    this.acceleration += 0.0052;
                    ++this.tick;
                    if (this.tick > 100) {
                        NeoForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        }.start();
        return stack.getCraftingRemainingItem();
    };

    public FilledWaterskinItem() {
        super(new Item.Properties().stacksTo(1).craftRemainder((Item)ModItems.WATERSKIN.get()).component(ModItemComponents.WATER_TEMPERATURE, (Object)0.0));
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_BEHAVIOR);
    }

    public static ItemStack getDisplayStack() {
        return new ItemStack((ItemLike)ModItems.FILLED_WATERSKIN.asItem());
    }

    public int getMaxDamage(ItemStack stack) {
        return ConfigSettings.WATERSKIN_USES.get();
    }

    public int getBarColor(ItemStack stack) {
        return 2973406;
    }

    public boolean isBarVisible(ItemStack stack) {
        return stack.getDamageValue() > 0;
    }

    private static int getDurability(ItemStack stack) {
        return Math.max(0, stack.getMaxDamage() - stack.getDamageValue());
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean isSelected) {
        super.inventoryTick(stack, world, entity, slot, isSelected);
        if (entity.tickCount % 5 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            double itemTemp = (Double)stack.get(ModItemComponents.WATER_TEMPERATURE);
            if (itemTemp != 0.0 && slot <= 8 || player.getOffhandItem().equals(stack)) {
                double drainAmt = 0.025 * ConfigSettings.WATERSKIN_NEUTRALIZE_SPEED.get();
                double newTemp = CSMath.shrink(itemTemp, drainAmt * 5.0);
                double tempEffect = 0.05 * ConfigSettings.WATERSKIN_HOTBAR_STRENGTH.get();
                stack.set(ModItemComponents.WATER_TEMPERATURE, (Object)newTemp);
                Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(tempEffect * (double)CSMath.sign(itemTemp)).expires(5), Temperature.Trait.CORE, Placement.LAST);
            }
        }
    }

    public static boolean performPourAction(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        block6: {
            block5: {
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (stack.is(ModItems.FILLED_WATERSKIN) && stack.has(ModItemComponents.WATER_TEMPERATURE)) break block6;
            }
            return false;
        }
        if (!player.level().isClientSide) {
            double temperature = (Double)stack.getOrDefault(ModItemComponents.WATER_TEMPERATURE, (Object)0.0);
            double effectAmount = temperature * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
            double wetnessTemp = 0.05 * (double)CSMath.sign(temperature == 0.0 ? 1.0 : temperature);
            Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(effectAmount).expires(0), Temperature.Trait.CORE, Placement.LAST);
            Placement modPlacement = Placement.of(Mode.REPLACE, Order.FIRST, mod -> mod instanceof WaterTempModifier).orElse(Placement.LAST);
            Temperature.addModifier((LivingEntity)player, new WaterTempModifier(wetnessTemp).tickRate(5), Temperature.Trait.WORLD, modPlacement);
            WorldHelper.playEntitySound((SoundEvent)ModSounds.WATERSKIN_POUR.value(), (Entity)player, player.getSoundSource(), 2.0f, (float)(Math.random() / 5.0 + 0.9));
        }
        FilledWaterskinItem.consumeWaterskin(stack, (LivingEntity)player, hand);
        player.swing(hand, true);
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleServer(() -> {
                ParticleBatchMessage particleBatch = new ParticleBatchMessage(2);
                for (int p = 0; p < 10; ++p) {
                    AABB playerBB = player.getDimensions(player.getPose()).makeBoundingBox(player.position()).inflate(0.2);
                    particleBatch.addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, Mth.lerp((double)rand.nextFloat(), (double)playerBB.minX, (double)playerBB.maxX), playerBB.maxY, Mth.lerp((double)rand.nextFloat(), (double)playerBB.minZ, (double)playerBB.maxZ), 0.3, 0.3, 0.3);
                }
                particleBatch.sendEntity((Entity)player);
            }, i);
        }
        player.getCooldowns().addCooldown((Item)ModItems.FILLED_WATERSKIN.value(), 10);
        player.getCooldowns().addCooldown((Item)ModItems.WATERSKIN.value(), 10);
        return true;
    }

    public static ItemStack consumeWaterskin(ItemStack stack, LivingEntity entity, InteractionHand usedHand) {
        Player player;
        ItemStack emptyStack = stack.getCraftingRemainingItem();
        if (entity instanceof Player && (player = (Player)entity).getInventory().contains(emptyStack)) {
            player.addItem(emptyStack);
            player.setItemInHand(usedHand, ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        entity.setItemInHand(usedHand, emptyStack);
        return emptyStack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching()) {
            return FilledWaterskinItem.performAction(Preference.getOrDefault(player, Preference.WATERSKIN_SECONDARY, Preference.WaterskinAction.DRINK), level, player, hand);
        }
        return FilledWaterskinItem.performAction(Preference.getOrDefault(player, Preference.WATERSKIN_PRIMARY, Preference.WaterskinAction.POUR), level, player, hand);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        super.onUseTick(level, entity, stack, remainingTicks);
        if (remainingTicks % 5 == 0 && remainingTicks < this.getUseDuration(stack, entity) - 5) {
            Vec3 playerPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            Vec3 lookVec = new Vec3(entity.getLookAngle().x, 0.0, entity.getLookAngle().z).normalize();
            Vec3 particlePos = playerPos.add(lookVec.scale(0.3));
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.SPLASH, particlePos.x, particlePos.y, particlePos.z, 0.2, 0.2, 0.2, 4.0, 0.0);
        }
    }

    private static InteractionResultHolder<ItemStack> performAction(Preference.WaterskinAction action, Level level, Player player, InteractionHand hand) {
        switch (action) {
            case DRINK: {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
            }
            case POUR: {
                if (!FilledWaterskinItem.performPourAction(player.getItemInHand(hand), (LivingEntity)player, hand)) break;
                return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (state.is(Blocks.CAULDRON) || state.is(Blocks.WATER_CAULDRON)) {
            int waterLevel;
            boolean hasWater = state.is(Blocks.WATER_CAULDRON);
            int n = waterLevel = hasWater ? (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) : 0;
            if (waterLevel >= 3) {
                return InteractionResult.PASS;
            }
            state = hasWater ? (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(waterLevel + 1)) : (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, state, 3);
            if (!level.isClientSide) {
                level.playSound(null, pos, (SoundEvent)ModSounds.WATERSKIN_FILL.value(), SoundSource.BLOCKS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
                WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.65, (double)pos.getZ() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            }
            if (player != null) {
                FilledWaterskinItem.consumeWaterskin(context.getItemInHand(), (LivingEntity)player, context.getHand());
                player.getCooldowns().addCooldown((Item)ModItems.WATERSKIN.value(), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        double amount = (Double)stack.get(ModItemComponents.WATER_TEMPERATURE) * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
        Temperature.addModifier(entity, new WaterskinTempModifier(amount / (double)(100 * stack.getMaxDamage())).expires(100), Temperature.Trait.CORE, Placement.LAST);
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return stack;
        }
        if (FilledWaterskinItem.getDurability(stack) <= 1) {
            return FilledWaterskinItem.consumeWaterskin(stack, entity, entity.getUsedItemHand());
        }
        stack.setDamageValue(stack.getDamageValue() + 1);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        double temp = CSMath.round((Double)stack.get(ModItemComponents.WATER_TEMPERATURE), 2);
        double multiplier = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0;
        MutableComponent filledLabel = Component.translatable((String)"item.cold_sweat.waterskin.filled").withStyle(ChatFormatting.GRAY);
        if (ConfigSettings.ENABLE_HINTS.get().booleanValue() && !TooltipHandler.isShiftDown()) {
            filledLabel.append((Component)Component.literal((String)" ").append(TooltipHandler.EXPAND_TOOLTIP));
        }
        tooltip.add((Component)filledLabel);
        int useEffect = (int)Math.round(temp * multiplier);
        MutableComponent tempText = useEffect > 0 ? Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + useEffect}).withStyle(TooltipHandler.HOT) : (useEffect == 0 ? Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + useEffect}).withStyle(ChatFormatting.WHITE) : Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{useEffect}).withStyle(TooltipHandler.COLD));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.cold_sweat.used").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)tempText);
        if (TooltipHandler.isShiftDown()) {
            if (ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
                String crouchKey = Minecraft.getInstance().options.keyShift.getKey().getDisplayName().getString();
                String crouchAction = switch (Preference.getOrDefault((Player)Minecraft.getInstance().player, Preference.WATERSKIN_SECONDARY, Preference.WaterskinAction.POUR)) {
                    case Preference.WaterskinAction.DRINK -> "tooltip.cold_sweat.waterskin.drink";
                    case Preference.WaterskinAction.POUR -> "tooltip.cold_sweat.waterskin.pour";
                    default -> "";
                };
                if (!crouchAction.isEmpty()) {
                    tooltip.add(2, (Component)Component.translatable((String)crouchAction, (Object[])new Object[]{Component.literal((String)crouchKey).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
            String perSecond = Component.translatable((String)"tooltip.cold_sweat.per_second").getString();
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.cold_sweat.hotbar").withStyle(ChatFormatting.GRAY));
            double effectRate = 0.5 * ConfigSettings.WATERSKIN_HOTBAR_STRENGTH.get();
            MutableComponent tempEffectText = (temp > 0.0 ? Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.round(effectRate, 2)}).withStyle(TooltipHandler.HOT) : (temp == 0.0 ? Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+0"}).withStyle(ChatFormatting.WHITE) : Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"-" + CSMath.round(effectRate, 2)}).withStyle(TooltipHandler.COLD))).append(perSecond);
            tooltip.add((Component)tempEffectText);
        }
        super.appendHoverText(stack, context, tooltip, advanced);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (stack.getItem() instanceof FilledWaterskinItem) {
            ItemStack emptyWaterskin = super.getCraftingRemainingItem(stack);
            emptyWaterskin.applyComponents(stack.getComponents());
            emptyWaterskin.remove(ModItemComponents.WATER_TEMPERATURE);
            emptyWaterskin.remove(DataComponents.DAMAGE);
            emptyWaterskin.remove(DataComponents.MAX_DAMAGE);
            emptyWaterskin.set(DataComponents.MAX_STACK_SIZE, (Object)emptyWaterskin.getItem().getDefaultMaxStackSize());
            if (CompatManager.isThirstLoaded()) {
                emptyWaterskin.remove(ThirstComponent.PURITY);
            }
            return emptyWaterskin;
        }
        return stack;
    }

    public String getDescriptionId() {
        return Component.translatable((String)"item.cold_sweat.waterskin").getString();
    }

    private static /* synthetic */ void lambda$static$2(Random rand, BlockPos pos, Level level) {
        ParticleBatchMessage particles = new ParticleBatchMessage(2);
        for (int p = 0; p < rand.nextInt(5) + 5; ++p) {
            particles.addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, new ParticleBatchMessage.ParticlePlacement((double)pos.getX() + rand.nextDouble(), (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), 0.0, 0.0, 0.0));
        }
        particles.sendWorld(level);
    }
}

