/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class WaterskinItem
extends Item {
    public static final int FLUID_VALUE_MB = 250;

    public WaterskinItem() {
        super(new Item.Properties().stacksTo(16));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player == null) {
            WorldHelper.dropItem(level, pos, WaterskinItem.getFilledItem(context.getItemInHand(), level, pos));
            return super.useOn(context);
        }
        if (player.getAbilities().mayBuild && state.getBlock() == Blocks.WATER_CAULDRON && (Integer)state.getValue((Property)BlockStateProperties.LEVEL_CAULDRON) > 0) {
            if (!player.isCreative()) {
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
            }
            WaterskinItem.handleFillWaterskin(player, context.getItemInHand(), context.getHand(), pos);
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.65, (double)pos.getZ() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            Optional.ofNullable((IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)context.getClickedFace())).ifPresent(cap -> {
                for (int i = 0; i < cap.getTanks(); ++i) {
                    FluidStack fluidStack = cap.getFluidInTank(i);
                    if (!fluidStack.getFluid().is(FluidTags.WATER) || fluidStack.getAmount() < 250) continue;
                    FluidStack drainStack = fluidStack.copy();
                    drainStack.setAmount(250);
                    cap.drain(drainStack, IFluidHandler.FluidAction.EXECUTE);
                    WaterskinItem.handleFillWaterskin(player, context.getItemInHand(), context.getHand(), pos);
                    return;
                }
            });
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder ar = super.use(level, player, hand);
        ItemStack itemstack = (ItemStack)ar.getObject();
        BlockHitResult blockhitresult = WaterskinItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos hitPos = blockhitresult.getBlockPos();
        BlockState lookingAt = level.getBlockState(hitPos);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (lookingAt.getFluidState().isSource() && lookingAt.getFluidState().getType().isSame((Fluid)Fluids.WATER)) {
            WaterskinItem.handleFillWaterskin(player, itemstack, hand, hitPos);
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.SPLASH, (double)hitPos.getX() + 0.5, hitPos.getY() + 1, (double)hitPos.getZ() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
        }
        return ar;
    }

    public static ItemStack getFilledItem(ItemStack stack, Level level, BlockPos pos) {
        ItemStack filledWaterskin = ((Item)ModItems.FILLED_WATERSKIN.value()).getDefaultInstance();
        filledWaterskin.applyComponents(stack.getComponents());
        filledWaterskin.set(ModItemComponents.WATER_TEMPERATURE, (Object)CSMath.clamp((WorldHelper.getTemperatureAt(level, pos) - CSMath.average(ConfigSettings.MAX_TEMP.get(), ConfigSettings.MIN_TEMP.get())) * 15.0, -50.0, 50.0));
        if (CompatManager.isThirstLoaded()) {
            filledWaterskin = CompatManager.Thirst.setPurityFromBlock(filledWaterskin, pos, level);
        }
        return filledWaterskin;
    }

    public static void handleFillWaterskin(Player player, ItemStack thisStack, InteractionHand usedHand, BlockPos filledAtPos) {
        Level level = player.level();
        ItemStack filledWaterskin = WaterskinItem.getFilledItem(thisStack, level, filledAtPos);
        if (thisStack.getCount() > 1 || player.getAbilities().instabuild) {
            ItemEntity itementity;
            if (!player.addItem(filledWaterskin) && (itementity = player.drop(filledWaterskin, false)) != null) {
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)player);
            }
            thisStack.shrink(1);
        } else {
            player.setItemInHand(usedHand, filledWaterskin);
        }
        player.swing(usedHand);
        player.getCooldowns().addCooldown((Item)ModItems.FILLED_WATERSKIN.value(), 10);
        player.awardStat(Stats.ITEM_USED.get((Object)thisStack.getItem()));
        level.playSound(null, filledAtPos, (SoundEvent)ModSounds.WATERSKIN_FILL.value(), SoundSource.PLAYERS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
    }

    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

