/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event.builder;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.kubejs.util.KubeHelper;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemTempBuilderJS {
    public final Set<Either<IntegerBounds, ItemTempData.SlotType>> slots = new HashSet<Either<IntegerBounds, ItemTempData.SlotType>>();
    public double temperature = 0.0;
    public double maxEffect = Double.POSITIVE_INFINITY;
    public double maxTemp;
    public double minTemp;
    public Temperature.Trait trait = Temperature.Trait.WORLD;
    public NegatableList<ItemRequirement> itemPredicate = new NegatableList();
    public NegatableList<EntityRequirement> entityPredicate = new NegatableList();
    public AttributeModifierMap attributes = new AttributeModifierMap();
    public Map<ResourceLocation, Double> immuneTempModifiers = new HashMap<ResourceLocation, Double>();

    public ItemTempBuilderJS items(String ... items) {
        List<Item> itemList = RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, ConfigHelper.getItems(items));
        if (itemList.isEmpty() && items.length != 0) {
            this.itemPredicate.add(ItemRequirement.NONE, true);
        } else {
            this.itemPredicate.add(new ItemRequirement(itemList, null), false);
        }
        return this;
    }

    public ItemTempBuilderJS temperature(double temperature) {
        this.temperature = temperature;
        return this;
    }

    public ItemTempBuilderJS maxEffect(double maxEffect) {
        this.maxEffect = maxEffect;
        return this;
    }

    public ItemTempBuilderJS maxTemp(double maxTemp) {
        this.maxTemp = maxTemp;
        return this;
    }

    public ItemTempBuilderJS minTemp(double minTemp) {
        this.minTemp = minTemp;
        return this;
    }

    public ItemTempBuilderJS trait(String trait) {
        this.trait = Temperature.Trait.fromID(trait);
        return this;
    }

    public ItemTempBuilderJS slots(int ... slots) {
        for (int slot : slots) {
            this.slots.add((Either<IntegerBounds, ItemTempData.SlotType>)Either.left((Object)new IntegerBounds(slot, slot)));
        }
        return this;
    }

    public ItemTempBuilderJS slotsInRange(int min, int max) {
        this.slots.add((Either<IntegerBounds, ItemTempData.SlotType>)Either.left((Object)new IntegerBounds(min, max)));
        return this;
    }

    public ItemTempBuilderJS equipmentSlots(String ... slots) {
        for (String slot : slots) {
            this.slots.add((Either<IntegerBounds, ItemTempData.SlotType>)Either.right((Object)((Object)ItemTempData.SlotType.byName(slot))));
        }
        return this;
    }

    public ItemTempBuilderJS itemPredicate(Predicate<ItemStack> itemPredicate) {
        this.itemPredicate.add(new ItemRequirement(itemPredicate), false);
        return this;
    }

    public ItemTempBuilderJS entityPredicate(Predicate<Entity> entityPredicate) {
        this.entityPredicate.add(new EntityRequirement(entityPredicate), false);
        return this;
    }

    public ItemTempBuilderJS attribute(String attributeId, double amount, String operation) {
        Holder attribute = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)attributeId)).orElse(null);
        if (!KubeHelper.expect(attributeId, attribute, Holder.class)) {
            return this;
        }
        this.attributes.put((Holder<Attribute>)attribute, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"kubejs"), amount, AttributeModifier.Operation.valueOf((String)operation.toUpperCase(Locale.ROOT))));
        return this;
    }

    public ItemTempBuilderJS immuneToModifier(String modifierId, double immunity) {
        ResourceLocation location = ResourceLocation.parse((String)modifierId);
        if (!TempModifierRegistry.getEntries().containsKey((Object)location)) {
            ColdSweat.LOGGER.warn("Tried to add immunity to non-existent temperature modifier: {}", (Object)location);
            return this;
        }
        this.immuneTempModifiers.put(ResourceLocation.parse((String)modifierId), immunity);
        return this;
    }

    public ItemTempData build() {
        ItemTempData data = new ItemTempData(this.itemPredicate, (List<Either<IntegerBounds, ItemTempData.SlotType>>)ImmutableList.copyOf(this.slots), this.temperature, this.trait, this.maxEffect, this.maxTemp, this.minTemp, this.entityPredicate, this.attributes, this.immuneTempModifiers);
        data.setConfigType(ConfigData.Type.KUBEJS);
        return data;
    }
}

