/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.spec.CSConfigSpec;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;

public class ItemSettingsConfig {
    private static final CSConfigSpec SPEC;
    private static final CSConfigSpec.Builder BUILDER;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> BOILER_FUELS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> ICEBOX_FUELS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> HEARTH_FUELS;
    public static final CSConfigSpec.ConfigValue<List<? extends String>> HEARTH_POTION_BLACKLIST;
    public static final CSConfigSpec.BooleanValue ALLOW_POTIONS_IN_HEARTH;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> SOULSPRING_LAMP_FUELS;
    public static final CSConfigSpec.ConfigValue<List<? extends String>> SOULSPRING_LAMP_DIMENSIONS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> FOOD_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> ITEM_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_ITEMS;
    public static final CSConfigSpec.ConfigValue<List<? extends String>> INSULATION_BLACKLIST;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_ARMOR;
    public static final CSConfigSpec.ConfigValue<List<?>> INSULATION_SLOTS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_SLOT_OVERRIDES;
    public static final CSConfigSpec.DoubleValue INSULATION_STRENGTH;
    public static final CSConfigSpec.IntValue WATERSKIN_CONSUME_STRENGTH;
    public static final CSConfigSpec.DoubleValue WATERSKIN_HOTBAR_STRENGTH;
    public static final CSConfigSpec.DoubleValue WATERSKIN_NEUTRALIZE_SPEED;
    public static final CSConfigSpec.IntValue WATERSKIN_USES;
    public static final CSConfigSpec.DoubleValue SOULSPRING_LAMP_STRENGTH;
    public static final CSConfigSpec.ConfigValue<Boolean> FIRE_RESISTANCE_BLOCKS_OVERHEATING;
    public static final CSConfigSpec.ConfigValue<Boolean> ICE_RESISTANCE_BLOCKS_FREEZING;
    public static final CSConfigSpec.ConfigValue<Boolean> REQUIRE_THERMOMETER;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> DRYING_ITEMS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_CURIOS;
    public static final CSConfigSpec.BooleanValue HEAT_DRAINS_BACKTANK;
    public static final CSConfigSpec.BooleanValue COLD_DRAINS_BACKTANK;

    public static void setup(ModContainer modContainer) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/item.toml");
    }

    public static void save() {
        SPEC.save();
    }

    static {
        BUILDER = new CSConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Anywhere that uses item IDs also supports:", " \u2022 Tags (e.g. \"#minecraft:planks\")", " \u2022 Comma-separated lists (e.g. \"minecraft:blaze_powder,#forge:rods/blaze\")", "     Applies the setting to all listed IDs. Can use tags, regular IDs, and negation interchangeably", " \u2022 Negation (e.g. \"!minecraft:black_dye\")", "     Useful with lists/tags. Excludes the listed IDs from the setting", "     i.e. \"#forge:dyes,!minecraft:black_dye\" (all dyes EXCEPT black dye)", " Settings with \"//v\" will list elements vertically. Removing \"//v\" will list elements in one line", "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines items that can be used as fuel", " \u2514\u2500\u2500 Format: [[\"item_id\", amount], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"minecraft:coal\").", " \u2022 amount: The amount of fuel the item provides. Higher values mean the item burns longer", " \u2304 ").push("Fuel Items");
        BOILER_FUELS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v").defineListAllowEmpty("Boiler", ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("#minecraft:coals", Integer.valueOf(55)), List.of("#minecraft:logs_that_burn", Integer.valueOf(40)), List.of("minecraft:dried_kelp_block", Integer.valueOf(40)), List.of("minecraft:coal_block", Integer.valueOf(500)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000))}).build(), () -> List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        ICEBOX_FUELS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v").defineListAllowEmpty(List.of("Icebox"), () -> ListBuilder.begin(new List[]{List.of("minecraft:snowball", Integer.valueOf(10)), List.of("minecraft:clay_ball", Integer.valueOf(37)), List.of("minecraft:snow_block", Integer.valueOf(40)), List.of("minecraft:ice", Integer.valueOf(250)), List.of("minecraft:clay", Integer.valueOf(333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(100)), List.of("minecraft:packed_ice", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        HEARTH_FUELS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " (Negative values indicate cold fuel").defineListAllowEmpty(List.of("Hearth"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("#minecraft:coals", Integer.valueOf(55)), List.of("#minecraft:logs_that_burn", Integer.valueOf(40)), List.of("minecraft:dried_kelp_block", Integer.valueOf(40)), List.of("minecraft:coal_block", Integer.valueOf(500)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000)), List.of("minecraft:snowball", Integer.valueOf(-10)), List.of("minecraft:clay_ball", Integer.valueOf(-37)), List.of("minecraft:snow_block", Integer.valueOf(-40)), List.of("minecraft:ice", Integer.valueOf(-250)), List.of("minecraft:clay", Integer.valueOf(-333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(-100)), List.of("minecraft:packed_ice", Integer.valueOf(-1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        BUILDER.pop();
        BUILDER.push("Hearth Extras");
        HEARTH_POTION_BLACKLIST = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Potions containing any of these effects will not be allowed in the hearth", " \u2514\u2500\u2500 Format: [\"effect_id\", \"effect_id\", ...etc]", " \u2304 ").defineListAllowEmpty(List.of("Blacklisted Hearth Potions"), () -> ListBuilder.begin(new String[]{"minecraft:instant_damage", "minecraft:poison", "minecraft:wither", "minecraft:weakness", "minecraft:mining_fatigue", "minecraft:slowness"}).build(), it -> it instanceof String);
        ALLOW_POTIONS_IN_HEARTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " If true, potions can be used in the hearth to give all players in range the potion effect", " \u2304 ").define("Allow Potions in Hearth", true);
        BUILDER.pop();
        BUILDER.push("Soulspring Lamp");
        SOULSPRING_LAMP_FUELS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that the Soulspring Lamp can use as fuel", " \u2514\u2500\u2500 Format: [[\"item_id\", amount], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"cold_sweat:soul_sprout\").", " \u2022 amount: The amount of fuel the item provides. Higher values mean the item burns longer", " \u2304 ").defineListAllowEmpty(List.of("Fuel Items"), () -> ListBuilder.begin(List.of("cold_sweat:soul_sprout", Integer.valueOf(4))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        SOULSPRING_LAMP_DIMENSIONS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the dimensions that the Soulspring Lamp can be used in", " \u2514\u2500\u2500 Format: [\"dimension_id\", \"dimension_id\", ...etc]", " \u2304 ").defineListAllowEmpty(List.of("Valid Dimensions"), () -> ListBuilder.begin("minecraft:the_nether").build(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Insulation");
        INSULATION_ITEMS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the items that can be used for insulating armor in the Sewing Table", " \u251c\u2500\u2500 Format (Static): [[\"item_id\", cold, heat, *\"static\", *\"{nbt}\", *fillSlots], [...], etc]", " \u251c\u2500\u2500 Format (Adaptive): [[\"item_id\", amount, adaptSpeed, \"adaptive\", *\"{nbt}\", *fillSlots], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 item_id: The item's ID (i.e. \"minecraft:iron_ingot\").", " \u2022 cold: The cold insulation the item provides.", " \u2022 heat: The heat insulation the item provides.", " \u2022 amount: The amount of insulation the item provides.", " \u2022 adaptSpeed: The speed at which the insulation adapts to the environment.", " \u2022 *static/adaptive: The type of insulation the item provides. Defaults to \"static\" if unset", " \u2022 *nbt: If set, the item will only provide insulation if it has the specified NBT tag.", " \u2022 *fillSlots: If true, the item will fill 1 slot per 2 insulation points. Otherwise, the item will fill 1 slot.", " \u2304 ").defineListAllowEmpty(List.of("Insulation Ingredients"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather", Integer.valueOf(1), Integer.valueOf(1)), List.of("cold_sweat:chameleon_molt", Integer.valueOf(2), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:hoglin_hide", Integer.valueOf(0), Integer.valueOf(2)), List.of("cold_sweat:goat_fur", Integer.valueOf(2), Integer.valueOf(0)), List.of("#minecraft:wool", Double.valueOf(1.5), Integer.valueOf(0)), List.of("minecraft:rabbit_hide", Integer.valueOf(0), Double.valueOf(1.5))}).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) && !(list.get(1) instanceof List) || !(list.get(2) instanceof Number) && !(list.get(2) instanceof List) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Boolean));
        });
        INSULATING_ARMOR = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the items that provide insulation when worn", " ** See Insulation Ingredients for formatting.", " Enabling \"fillSlots\" will cause the armor's built-in insulation to consume the available insulation slots", " i.e. if an item has 5 insulation slots and gives one slot of cold insulation by default, it will only have 4 free slots left", " \u2304 ").defineListAllowEmpty(List.of("Insulating Armor"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather_helmet", Integer.valueOf(5), Integer.valueOf(5)), List.of("minecraft:leather_chestplate", Integer.valueOf(7), Integer.valueOf(7)), List.of("minecraft:leather_leggings", Integer.valueOf(6), Integer.valueOf(6)), List.of("minecraft:leather_boots", Integer.valueOf(5), Integer.valueOf(5)), List.of("cold_sweat:hoglin_helmet", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:hoglin_chestplate", Integer.valueOf(0), Integer.valueOf(14)), List.of("cold_sweat:hoglin_leggings", Integer.valueOf(0), Integer.valueOf(12)), List.of("cold_sweat:hoglin_boots", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:goat_fur_helmet", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_chestplate", Integer.valueOf(14), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_leggings", Integer.valueOf(12), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_boots", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:chameleon_helmet", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:chameleon_chestplate", Integer.valueOf(14), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:chameleon_leggings", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:chameleon_boots", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive")}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_pants", Double.valueOf(7.5), Integer.valueOf(-5)))).addIf(CompatManager.isToughAsNailsLoaded(), () -> List.of("toughasnails:leaf_helmet", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_chestplate", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_leggings", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_boots", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_helmet", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_chestplate", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_leggings", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_boots", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) && !(list.get(1) instanceof List) || !(list.get(2) instanceof Number) && !(list.get(2) instanceof List) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(5) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Boolean));
        });
        INSULATING_CURIOS = CompatManager.isCuriosLoaded() ? BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the items that provide insulation when worn in a curio slot", " See Insulation Ingredients for formatting. This setting does not have a \"fillSlots\" option", " \u2304 ").defineListAllowEmpty(List.of("Insulating Curios"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        }) : null;
        INSULATION_SLOTS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how many insulation slots armor pieces have", " There are 4 modes for this setting:", " \u250c Static: Each armor slot (head, body, legs, feet) has a fixed number of insulation slots", " \u2514\u2500\u2500\u2500 Format: [head, body, legs, feet]", "      \u2022 head/body/legs/feet: The number of insulation slots for that armor slot", " \u250c Linear: Number of slots increases steadily with protection", " \u251c Exponential: Number of slots increases exponentially with protection", " \u251c Logarithmic: Number of slots increases with protection, with diminishing returns", " \u2514\u2500\u2500\u2500 Format: [multiplier, max-slots]", "      \u2022 multiplier: Multiplied by the armor's protection value to get the number of insulation slots", "      \u2022 max-slots: The maximum number of insulation slots an armor piece can have", " \u2304 ").defineList("Insulation Slots", List.of("static", Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(5), Integer.valueOf(4)), it -> it instanceof Number || it instanceof String);
        INSULATION_SLOT_OVERRIDES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Allows for overriding the number of insulation slots for specific items", " \u2514\u2500\u2500 Format: [[\"item_id\", slotCount, *\"{nbt}\"], [\"item_id\", slotCount, *\"{nbt}\"], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"minecraft:iron_helmet\").", " \u2022 slot_count: The number of insulation slots the item should have.", " \u2022 *nbt: If set, the item will only have the specified number of insulation slots if it has the specified NBT tag.", " \u2304 ").defineListAllowEmpty(List.of("Insulation Slot Overrides"), () -> List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        INSULATION_STRENGTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines the effectiveness of insulating items in protecting against temperature", " \u2304 ").defineInRange("Insulation Strength", 1.0, 0.0, Double.POSITIVE_INFINITY);
        INSULATION_BLACKLIST = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines wearable items that cannot be insulated", " \u2514\u2500\u2500 Format: [\"item_id\", \"item_id\", ...etc]", " \u2304 ").defineListAllowEmpty(List.of("Insulation Blacklist"), () -> List.of(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Consumables");
        FOOD_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that affect the player's temperature when consumed", " \u251c\u2500\u2500 Format: [[\"item_id\", amount, *\"{nbt}\", *duration, *stack_limit], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 item_id: The item's ID (i.e. \"minecraft:apple\").", " \u2022 amount: The amount to change the player's temperature by. Negative values are cold, positive values are hot", " \u2022 *nbt: If set, the item will only affect the player's temperature if it has the specified NBT tag.", " \u2022 *duration: If set, the player's temperature will remain increased/decreased for this amount of time (in ticks).", " \u2022 *stack_limit: If set, consuming multiple of the same item will apply stacking effects up to this limit.", " \u2304 ").defineListAllowEmpty(List.of("Temperature-Affecting Foods"), () -> Arrays.asList(List.of("cold_sweat:soul_sprout", Integer.valueOf(-20), "{}", Integer.valueOf(1200))), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 2 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof String) || list.size() >= 4 && !(list.get(3) instanceof Number));
        });
        WATERSKIN_CONSUME_STRENGTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how much a waterskin will change the player's body temperature when used", " \u2304 ").defineInRange("Waterskin Strength", 50, 0, Integer.MAX_VALUE);
        WATERSKIN_HOTBAR_STRENGTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " A multiplier for how effective a waterskin's over-time effect is, when held in the player's hotbar", " \u2304 ").defineInRange("Waterskin Hotbar Strength", 1.0, 0.0, Double.POSITIVE_INFINITY);
        WATERSKIN_NEUTRALIZE_SPEED = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " A multiplier for how quickly a waterskin will return to its neutral temperature when being used in the hotbar", " \u2304 ").defineInRange("Waterskin Neutralize Speed", 1.0, 0.0, Double.POSITIVE_INFINITY);
        WATERSKIN_USES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how many times a waterskin can be used before becoming empty", " \u2304 ").defineInRange("Waterskin Uses", 1, 1, Integer.MAX_VALUE);
        SOULSPRING_LAMP_STRENGTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Determines the strength of the Soulspring Lamp's effect before it is overwhelmed", " A value of 1 means it will never be overwhelmed", " \u2304 ").defineInRange("Soulspring Lamp Strength", 0.6, 0.0, 1.0);
        DRYING_ITEMS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that can be used to dry the player", " \u2514\u2500\u2500 Format: [[\"item_id\", \"turns_into\"], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"minecraft:sponge\").", " \u2022 turns_into: The item to be turned into when the item is used (i.e. \"minecraft:wet_sponge\").", " \u2304 ").defineListAllowEmpty(List.of("Drying Items"), () -> List.of(List.of("minecraft:sponge", "minecraft:wet_sponge")), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof String;
        });
        BUILDER.pop();
        BUILDER.push("Misc");
        ITEM_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that affect the player's temperature when in the inventory", " \u251c\u2500\u2500 Format: [[\"item_id\", temperature, \"slotRange\", \"trait\", *\"{nbt}\", *maxEffect, *tempLimit], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 item_id: The item's ID (i.e. \"minecraft:lava_bucket\").", " \u2022 temperature: The temperature change the item will apply to the entity. For core temperature, this is applied every tick", " \u2022 slot_range: Either \"inventory\", \"hotbar\", or \"hand\". Defines what slots the item must be in to apply to the entity (inventory includes hotbar)", " \u2022 trait: The temperature trait to apply the effect to. Typical values are \"core\" for body temperature or \"world\" for ambient temperature. More on the mod documentation page.", " \u2022 *nbt: The NBT data the item must have to apply to the entity.", " \u2022 *max_effect: The maximum temperature effect the item can apply to the entity.", " \u2022 *tempLimit: The maximum temperature at which this item temp will have any effect.", "   (Based on the given trait. Represents the minimum temp if the item temp is negative)", " \u2304 ").defineListAllowEmpty(List.of("Item Temperatures"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || !((list = (List)it).get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof String) || !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Number) || list.size() >= 7 && !(list.get(6) instanceof Number));
        });
        BUILDER.pop();
        BUILDER.push("Item Functions");
        FIRE_RESISTANCE_BLOCKS_OVERHEATING = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allow fire resistance to block overheating damage", " \u2304 ").define("Fire Resistance Immunity", defaultDiff.getOrDefault(ConfigSettings.FIRE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        ICE_RESISTANCE_BLOCKS_FREEZING = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allow ice resistance to block freezing damage", " \u2304 ").define("Ice Resistance Immunity", defaultDiff.getOrDefault(ConfigSettings.ICE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        REQUIRE_THERMOMETER = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Whether a thermometer is required to see exact world and body temperature", " \u2304 ").define("Require Thermometer", defaultDiff.getOrDefault(ConfigSettings.REQUIRE_THERMOMETER, Boolean.valueOf(true)));
        BUILDER.pop();
        if (CompatManager.isCreateLoaded()) {
            BUILDER.comment(" Drains pressure from Create's netherite backtank if the player is in a hot/cold environment", " Triggered by the set bonus for wearing a full set of netherite diving gear", " Disabling these settings will not disable the heat/cold protection set bonus", " \u2304 ").push("Create Backtank");
            HEAT_DRAINS_BACKTANK = BUILDER.define("Heat Drains Backtank", true);
            COLD_DRAINS_BACKTANK = BUILDER.define("Cold Drains Backtank", false);
            BUILDER.pop();
        } else {
            HEAT_DRAINS_BACKTANK = null;
            COLD_DRAINS_BACKTANK = null;
        }
        SPEC = BUILDER.build();
    }
}

