/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModPotions;
import com.momosoftworks.coldsweat.util.item.PotionUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber
public class PotionRecipes {
    @SubscribeEvent
    public static void register(RegisterBrewingRecipesEvent event) {
        Ingredient awkward = PotionRecipes.createPotion((Holder<Potion>)Potions.AWKWARD);
        Ingredient icePotionIngredient = PotionRecipes.createPotion(ModPotions.ICE_RESISTANCE);
        ItemStack icePotion = PotionUtils.setPotion(Items.POTION.getDefaultInstance(), ModPotions.ICE_RESISTANCE);
        ItemStack longIcePotion = PotionUtils.setPotion(Items.POTION.getDefaultInstance(), ModPotions.LONG_ICE_RESISTANCE);
        event.getBuilder().addRecipe((IBrewingRecipe)new BrewingRecipe(awkward, Ingredient.of((ItemLike[])new ItemLike[]{ModItems.SOUL_SPROUT}), icePotion));
        event.getBuilder().addRecipe((IBrewingRecipe)new BrewingRecipe(icePotionIngredient, Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), longIcePotion));
    }

    private static Ingredient createPotion(Holder<Potion> potion) {
        DataComponentIngredient ingredientComponents = new DataComponentIngredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.POTION)}), DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion)).build(), false);
        return new Ingredient((ICustomIngredient)ingredientComponents);
    }
}

