/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BlockDataUpdateMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<BlockDataUpdateMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"block_data_update"));
    public static final StreamCodec<FriendlyByteBuf, BlockDataUpdateMessage> CODEC = CustomPacketPayload.codec(BlockDataUpdateMessage::encode, BlockDataUpdateMessage::decode);
    BlockPos blockPos;
    CompoundTag tag;

    public BlockDataUpdateMessage(BlockEntity blockEntity) {
        this.blockPos = blockEntity.getBlockPos();
        this.tag = blockEntity.getUpdateTag((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
    }

    public BlockDataUpdateMessage(BlockPos blockPos, CompoundTag tag) {
        this.blockPos = blockPos;
        this.tag = tag;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.blockPos);
        buffer.writeNbt((Tag)this.tag);
    }

    public static BlockDataUpdateMessage decode(FriendlyByteBuf buffer) {
        return new BlockDataUpdateMessage(buffer.readBlockPos(), buffer.readNbt());
    }

    public static void handle(BlockDataUpdateMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity be;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (be = level.getBlockEntity(message.blockPos)) != null) {
                be.handleUpdateTag(message.tag, (HolderLookup.Provider)context.player().registryAccess());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

