/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RegistryModifierData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ModRegistries {
    private static final Map<ResourceLocation, RegistryHolder<? extends ConfigData>> REGISTRIES = new FastMap<ResourceLocation, RegistryHolder<? extends ConfigData>>();
    public static final RegistryHolder<InsulatorData> INSULATOR_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/insulator"), InsulatorData.CODEC);
    public static final RegistryHolder<FuelData> FUEL_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/fuel"), FuelData.CODEC);
    public static final RegistryHolder<FoodData> FOOD_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/food"), FoodData.CODEC);
    public static final RegistryHolder<ItemTempData> ITEM_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/item_temp"), ItemTempData.CODEC);
    public static final RegistryHolder<DryingItemData> DRYING_ITEM_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/drying_item"), DryingItemData.CODEC);
    public static final RegistryHolder<ItemInsulationSlotsData> INSULATION_SLOTS_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"item/insulation_slots"), ItemInsulationSlotsData.CODEC);
    public static final RegistryHolder<BlockTempData> BLOCK_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"block/block_temp"), BlockTempData.CODEC);
    public static final RegistryHolder<BiomeTempData> BIOME_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/biome_temp"), BiomeTempData.CODEC);
    public static final RegistryHolder<DimensionTempData> DIMENSION_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/dimension_temp"), DimensionTempData.CODEC);
    public static final RegistryHolder<StructureTempData> STRUCTURE_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/structure_temp"), StructureTempData.CODEC);
    public static final RegistryHolder<DepthTempData> DEPTH_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world/temp_region"), DepthTempData.CODEC);
    public static final RegistryHolder<MountData> MOUNT_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/mount"), MountData.CODEC);
    public static final RegistryHolder<SpawnBiomeData> ENTITY_SPAWN_BIOME_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/spawn_biome"), SpawnBiomeData.CODEC);
    public static final RegistryHolder<EntityTempData> ENTITY_TEMP_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/entity_temp"), EntityTempData.CODEC);
    public static final RegistryHolder<EntityClimateData> ENTITY_CLIMATE_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/climate"), EntityClimateData.CODEC);
    public static final RegistryHolder<TempEffectsData> TEMP_EFFECTS_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"entity/temp_effects"), TempEffectsData.CODEC);
    public static final RegistryHolder<RegistryModifierData<?>> REGISTRY_MODIFIER_DATA = ModRegistries.createRegistry(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"modifier"), RegistryModifierData.CODEC);

    public static <V extends ConfigData> RegistryHolder<V> createRegistry(ResourceLocation registry, Codec<V> codec) {
        RegistryHolder<V> registryHolder = new RegistryHolder<V>(ResourceKey.createRegistryKey((ResourceLocation)registry), codec);
        REGISTRIES.put(registry, registryHolder);
        return registryHolder;
    }

    @Deprecated
    public static <V extends ConfigData> RegistryHolder<V> createRegistry(ResourceLocation registry, Codec<V> codec, Class<V> type) {
        return ModRegistries.createRegistry(registry, codec);
    }

    public static Map<ResourceLocation, RegistryHolder<?>> getRegistries() {
        return ImmutableMap.copyOf(REGISTRIES);
    }

    public static ResourceKey<? extends Registry<? extends ConfigData>> getRegistryKey(ResourceLocation name) {
        return Optional.ofNullable(REGISTRIES.get(name)).map(RegistryHolder::key).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + String.valueOf(name))));
    }

    public static <T extends ConfigData> RegistryHolder<T> getRegistry(ResourceKey<Registry<T>> key) {
        return Optional.ofNullable(REGISTRIES.get(key.location())).map(reg -> reg).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + String.valueOf(key.location()))));
    }

    public static <T extends ConfigData> Codec<T> getCodec(ResourceKey<Registry<T>> registry) {
        return Optional.of(REGISTRIES.get(registry.location())).map(RegistryHolder::codec).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + registry.location().getPath())));
    }
}

