/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class DepthTempData
extends ConfigData {
    final List<TempRegion> temperatures;
    final NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions;
    public static final Codec<DepthTempData> CODEC = DepthTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)TempRegion.CODEC.listOf().fieldOf("regions").forGetter(DepthTempData::temperatures), (App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registries.DIMENSION_TYPE)).fieldOf("dimensions").forGetter(DepthTempData::dimensions)).apply((Applicative)instance, DepthTempData::new)));

    public DepthTempData(List<TempRegion> temperatures, NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.temperatures = temperatures;
        this.dimensions = dimensions;
    }

    public DepthTempData(List<TempRegion> temperatures, NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions) {
        this(temperatures, dimensions, new NegatableList<String>());
    }

    public List<TempRegion> temperatures() {
        return this.temperatures;
    }

    public NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions() {
        return this.dimensions;
    }

    public boolean withinBounds(Level level, BlockPos pos) {
        return this.getRegion(level, pos) != null;
    }

    @Nullable
    public TempRegion getRegion(Level level, BlockPos pos) {
        Holder dim = level.dimensionTypeRegistration();
        if (!this.dimensions.test(either -> (Boolean)either.map(arg_0 -> ((Holder)dim).is(arg_0), h -> h.is(dim)))) {
            return null;
        }
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return region;
        }
        return null;
    }

    @Nullable
    public Double getTemperature(double temperature, BlockPos pos, Level level) {
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return region.getTemperature(temperature, pos, level, region.top.getHeight(pos, level), region.bottom.getHeight(pos, level));
        }
        return null;
    }

    public Codec<DepthTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DepthTempData that = (DepthTempData)obj;
        return super.equals(obj) && this.temperatures.equals(that.temperatures) && this.dimensions.equals(that.dimensions);
    }

    public record TempRegion(RampType rampType, VerticalBound top, VerticalBound bottom) {
        public static final TempRegion NONE = new TempRegion(RampType.CONSTANT, VerticalBound.NONE, VerticalBound.NONE);
        public static final Codec<TempRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RampType.CODEC.optionalFieldOf("type", (Object)RampType.CONSTANT).forGetter(TempRegion::rampType), (App)VerticalBound.CODEC.optionalFieldOf("top", (Object)VerticalBound.NONE).forGetter(TempRegion::top), (App)VerticalBound.CODEC.optionalFieldOf("bottom", (Object)VerticalBound.NONE).forGetter(TempRegion::bottom)).apply((Applicative)instance, (type, top, bottom) -> {
            if (top == VerticalBound.NONE && bottom == VerticalBound.NONE) {
                throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Temperature region must have at least one bound"));
            }
            if (top == VerticalBound.NONE) {
                if (type != RampType.CONSTANT) {
                    throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"top\" region undefined. Boundless temperature region must have a constant temperature"));
                }
                top = new VerticalBound(VerticalAnchor.CONSTANT, Integer.MAX_VALUE, bottom.units, bottom.temperature);
            }
            if (bottom == VerticalBound.NONE) {
                if (type != RampType.CONSTANT) {
                    throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"bottom\" region undefined. Boundless temperature region must have a constant temperature"));
                }
                bottom = new VerticalBound(VerticalAnchor.CONSTANT, Integer.MIN_VALUE, top.units, top.temperature);
            }
            if (type == RampType.CONSTANT && !top.temperature.equals(bottom.temperature)) {
                throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Constant temperature ramp type must have a constant temperature; got " + String.valueOf(top.temperature) + " and " + String.valueOf(bottom.temperature)));
            }
            return new TempRegion((RampType)((Object)((Object)type)), (VerticalBound)top, (VerticalBound)bottom);
        }));

        public boolean withinBounds(Level level, BlockPos pos) {
            return pos.getY() <= this.top.getHeight(pos, level) && pos.getY() >= this.bottom.getHeight(pos, level);
        }

        public double getTemperature(double temperature, BlockPos pos, Level level, int topHeight, int bottomHeight) {
            double topTemp = Temperature.convert(this.top.getTemperature(temperature), this.top.units, Temperature.Units.MC, true);
            double bottomTemp = Temperature.convert(this.bottom.getTemperature(temperature), this.bottom.units, Temperature.Units.MC, true);
            return switch (this.rampType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (pos.getY() <= this.bottom.getHeight(pos, level)) {
                        yield bottomTemp;
                    }
                    yield topTemp;
                }
                case 1 -> CSMath.blend(bottomTemp, topTemp, (double)pos.getY(), (double)bottomHeight, (double)topHeight);
                case 2 -> CSMath.blendExp(bottomTemp, topTemp, (double)pos.getY(), (double)bottomHeight, (double)topHeight);
                case 3 -> CSMath.blendLog(bottomTemp, topTemp, (double)pos.getY(), (double)bottomHeight, (double)topHeight, 1.0);
            };
        }

        @Override
        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TempRegion that = (TempRegion)obj;
            return this.rampType == that.rampType && this.top.equals(that.top) && this.bottom.equals(that.bottom);
        }
    }

    public record VerticalBound(VerticalAnchor anchor, Integer depth, Temperature.Units units, TempContainer temperature) {
        public static final VerticalBound NONE = new VerticalBound(VerticalAnchor.CONSTANT, 0, Temperature.Units.MC, TempContainer.NONE);
        public static final Codec<VerticalBound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.optionalFieldOf("anchor", (Object)VerticalAnchor.CONSTANT).forGetter(VerticalBound::anchor), (App)Codec.INT.fieldOf("depth").forGetter(VerticalBound::depth), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(VerticalBound::units), (App)TempContainer.CODEC.fieldOf("temperature").forGetter(VerticalBound::temperature)).apply((Applicative)instance, VerticalBound::new));

        public int getHeight(BlockPos checkPos, Level level) {
            return switch (this.anchor.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.depth;
                case 1 -> level.getMaxBuildHeight() + this.depth;
                case 2 -> level.getMinBuildHeight() + this.depth;
                case 3 -> WorldHelper.getHeight(checkPos, level, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES) + this.depth;
            };
        }

        public double getTemperature(double temperature) {
            return switch (this.temperature.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (this.temperature.strength == 0.0) {
                        yield temperature;
                    }
                    yield CSMath.blend(temperature, this.temperature.temperature, this.temperature.strength, 0.0, 1.0);
                }
                case 1 -> this.temperature.strength == 0.0 ? temperature : CSMath.blend(temperature, (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0, this.temperature.strength, 0.0, 1.0);
            };
        }

        @Override
        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VerticalBound that = (VerticalBound)obj;
            return this.anchor == that.anchor && this.depth.equals(that.depth) && this.units == that.units && this.temperature.equals(that.temperature);
        }

        public record TempContainer(double temperature, ContainerType type, double strength) {
            public static final TempContainer NONE = new TempContainer(0.0, ContainerType.STATIC, 1.0);
            public static final Codec<TempContainer> CODEC = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("value", (Object)Double.NaN).forGetter(TempContainer::temperature), (App)ContainerType.CODEC.optionalFieldOf("type", (Object)ContainerType.STATIC).forGetter(TempContainer::type), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("strength", (Object)1.0).forGetter(TempContainer::strength)).apply((Applicative)instance, (temp, type, strength) -> {
                if (type == ContainerType.STATIC && temp.equals(Double.NaN) && strength > 0.0) {
                    throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Static temperature container must have a temperature"));
                }
                return new TempContainer((double)temp, (ContainerType)((Object)((Object)type)), (double)strength);
            })), (Codec)Codec.DOUBLE.xmap(d -> new TempContainer((double)d, ContainerType.STATIC, 1.0), TempContainer::temperature)).xmap(either -> (TempContainer)either.map(c -> c, c -> c), container -> container.type == ContainerType.STATIC ? Either.right((Object)container) : Either.left((Object)container));

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof TempContainer)) return false;
                TempContainer container = (TempContainer)obj;
                if (!Double.valueOf(container.temperature).equals(this.temperature)) return false;
                if (container.type != this.type) return false;
                if (container.strength != this.strength) return false;
                return true;
            }
        }

        public static enum ContainerType implements StringRepresentable
        {
            STATIC("static"),
            MIDPOINT("midpoint");

            private final String name;
            public static final Codec<ContainerType> CODEC;

            private ContainerType(String name) {
                this.name = name;
            }

            public String getSerializedName() {
                return this.name;
            }

            public static ContainerType byName(String name) {
                return (ContainerType)EnumHelper.byName((Enum[])ContainerType.values(), (String)name);
            }

            static {
                CODEC = ExtraCodecs.enumIgnoreCase((Enum[])ContainerType.values());
            }
        }
    }

    public static enum VerticalAnchor implements StringRepresentable
    {
        CONSTANT("constant"),
        WORLD_TOP("world_top"),
        WORLD_BOTTOM("world_bottom"),
        GROUND_LEVEL("ground_level");

        private final String name;
        public static final Codec<VerticalAnchor> CODEC;

        private VerticalAnchor(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static VerticalAnchor byName(String name) {
            return (VerticalAnchor)EnumHelper.byName((Enum[])VerticalAnchor.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])VerticalAnchor.values());
        }
    }

    public static enum RampType implements StringRepresentable
    {
        CONSTANT("constant"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        private final String name;
        public static final Codec<RampType> CODEC;

        private RampType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static RampType byName(String name) {
            return (RampType)EnumHelper.byName((Enum[])RampType.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])RampType.values());
        }
    }
}

