/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement.sub_type;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntityVariantRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.FishingHookRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.LightningBoltRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.PiglinNeutralArmorRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.PlayerDataRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.RaiderRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.SlimeRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.SnowBootsRequirement;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface EntitySubRequirement {
    public static final BiMap<ResourceLocation, Supplier<MapCodec<? extends EntitySubRequirement>>> REQUIREMENT_MAP = HashBiMap.create(Map.of(ResourceLocation.withDefaultNamespace((String)"variant"), () -> EntityVariantRequirement.CODEC, ResourceLocation.withDefaultNamespace((String)"fishing_hook"), () -> FishingHookRequirement.CODEC, ResourceLocation.withDefaultNamespace((String)"lightning_bolt"), () -> LightningBoltRequirement.CODEC, ResourceLocation.withDefaultNamespace((String)"piglin_neutral_armor"), () -> PiglinNeutralArmorRequirement.CODEC, ResourceLocation.withDefaultNamespace((String)"player"), () -> PlayerDataRequirement.getCodec(EntityRequirement.getCodec()), ResourceLocation.withDefaultNamespace((String)"raider"), () -> RaiderRequirement.CODEC, ResourceLocation.withDefaultNamespace((String)"slime"), () -> SlimeRequirement.CODEC, ResourceLocation.withDefaultNamespace((String)"snow_boots"), () -> SnowBootsRequirement.CODEC));
    public static final Codec<EntitySubRequirement> CODEC = ResourceLocation.CODEC.dispatch("type", requirement -> {
        Supplier matchingSupplier = REQUIREMENT_MAP.values().stream().filter(supplier -> ((MapCodec)supplier.get()).equals(requirement.getCodec())).findFirst().orElseThrow(() -> new IllegalStateException("Unknown requirement type: " + String.valueOf(requirement.getClass())));
        return (ResourceLocation)REQUIREMENT_MAP.inverse().get((Object)matchingSupplier);
    }, location -> {
        Supplier supplier = (Supplier)REQUIREMENT_MAP.get(location);
        if (supplier == null) {
            throw new IllegalStateException("Unknown requirement type: " + String.valueOf(location));
        }
        return (MapCodec)supplier.get();
    });

    default public ResourceLocation getType() {
        return (ResourceLocation)REQUIREMENT_MAP.inverse().get(this.getCodec());
    }

    public boolean test(Entity var1, Level var2, @Nullable Vec3 var3);

    public MapCodec<? extends EntitySubRequirement> getCodec();
}

