/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.util.math.CSMath;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record IntegerBounds(int min, int max) {
    public static final Codec<IntegerBounds> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)-2147483647).forGetter(bounds -> bounds.min), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(bounds -> bounds.max)).apply((Applicative)instance, IntegerBounds::new));
    public static final Codec<IntegerBounds> CODEC = Codec.either(DIRECT_CODEC, (Codec)Codec.INT).xmap(either -> (IntegerBounds)either.map(left -> left, right -> new IntegerBounds((int)right, (int)right)), bounds -> bounds.max == bounds.min ? Either.right((Object)bounds.min) : Either.left((Object)bounds));
    public static final StreamCodec<ByteBuf, IntegerBounds> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    public static IntegerBounds NONE = new IntegerBounds(-2147483647, Integer.MAX_VALUE);

    public IntegerBounds(Integer[] bounds) {
        this(bounds[0], bounds[1]);
    }

    public boolean test(int value) {
        return CSMath.betweenInclusive(value, this.min, this.max);
    }

    public boolean contains(IntegerBounds bounds) {
        return this.test(bounds.min()) && this.test(bounds.max());
    }

    public int getRandom() {
        int realMin = Math.min(this.min, this.max);
        int realMax = Math.max(this.min, this.max);
        return realMin + (int)(Math.random() * (double)(realMax - realMin + 1));
    }

    public int clamp(int value) {
        int realMin = Math.min(this.min, this.max);
        int realMax = Math.max(this.min, this.max);
        return CSMath.clamp(value, realMin, realMax);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerBounds that = (IntegerBounds)obj;
        if (!Objects.equals(this.min, that.min)) {
            return false;
        }
        return Objects.equals(this.max, that.max);
    }
}

