/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.api.event.vanilla.BlockStateChangedEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class MixinBlockUpdate {

    @Mixin(value={ClientLevel.class})
    public static final class Client {
        @Inject(method={"sendBlockUpdated"}, at={@At(value="HEAD")})
        private void onBlockUpdate(BlockPos pos, BlockState oldState, BlockState newState, int flags, CallbackInfo ci) {
            NeoForge.EVENT_BUS.post((Event)new BlockStateChangedEvent(pos, (Level)((ClientLevel)this), oldState, newState));
        }
    }

    @Mixin(value={ServerLevel.class})
    public static final class Server {
        ServerLevel level = (ServerLevel)this;

        @Inject(method={"onBlockStateChange"}, at={@At(value="HEAD")})
        private void onBlockUpdate(BlockPos pos, BlockState oldState, BlockState newState, CallbackInfo ci) {
            if (!oldState.equals(newState)) {
                this.level.getServer().execute(() -> NeoForge.EVENT_BUS.post((Event)new BlockStateChangedEvent(pos, (Level)this.level, oldState, newState)));
            }
        }
    }
}

