/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VehicleEntity.class})
public class MixinMinecart {
    VehicleEntity vehicle = (VehicleEntity)this;

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/VehicleEntity;destroy(Lnet/minecraft/world/damagesource/DamageSource;)V")}, cancellable=true)
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> ci) {
        Minecart minecart;
        ItemStack carryStack;
        VehicleEntity vehicleEntity = this.vehicle;
        if (vehicleEntity instanceof Minecart && !(carryStack = (minecart = (Minecart)vehicleEntity).getDisplayBlockState().getBlock().asItem().getDefaultInstance()).isEmpty()) {
            if (minecart.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                if (minecart.getDisplayBlockState().getBlock() == ModBlocks.MINECART_INSULATION.value()) {
                    ItemStack itemstack = new ItemStack((ItemLike)ModItems.INSULATED_MINECART.value());
                    if (minecart.hasCustomName()) {
                        itemstack.set(DataComponents.CUSTOM_NAME, (Object)minecart.getCustomName());
                    }
                    minecart.spawnAtLocation(itemstack);
                } else {
                    ItemStack itemstack = new ItemStack((ItemLike)Items.MINECART);
                    if (minecart.hasCustomName()) {
                        itemstack.set(DataComponents.CUSTOM_NAME, (Object)minecart.getCustomName());
                    }
                    minecart.spawnAtLocation(itemstack);
                    minecart.spawnAtLocation(carryStack);
                }
            }
            minecart.remove(Entity.RemovalReason.KILLED);
            ci.cancel();
        }
    }
}

