/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class NBTHelper {
    private NBTHelper() {
    }

    public static CompoundTag modifierToTag(TempModifier modifier) {
        CompoundTag modifierTag = new CompoundTag();
        ResourceLocation modifierId = TempModifierRegistry.getKey(modifier);
        if (modifierId == null) {
            ColdSweat.LOGGER.error("Failed to get key for TempModifier: {}", (Object)modifier.getClass().getSimpleName());
            return modifierTag;
        }
        modifierTag.putString("Id", modifierId.toString());
        modifierTag.put("ModifierData", (Tag)modifier.getNBT());
        if (modifier.getExpireTime() != -1) {
            modifierTag.putInt("ExpireTicks", modifier.getExpireTime());
        }
        if (modifier.getTickRate() > 1) {
            modifierTag.putInt("TickRate", modifier.getTickRate());
        }
        modifierTag.putInt("TicksExisted", modifier.getTicksExisted());
        modifierTag.putInt("Hash", modifier.hashCode());
        return modifierTag;
    }

    public static Optional<TempModifier> tagToModifier(CompoundTag modifierTag) {
        Optional<TempModifier> optional = TempModifierRegistry.getValue(ResourceLocation.parse((String)modifierTag.getString("Id")));
        optional.ifPresent(modifier -> {
            modifier.setNBT(modifierTag.getCompound("ModifierData"));
            if (modifierTag.contains("ExpireTicks")) {
                modifier.expires(modifierTag.getInt("ExpireTicks"));
            }
            if (modifierTag.contains("TickRate")) {
                modifier.tickRate(modifierTag.getInt("TickRate"));
            }
            modifier.setTicksExisted(modifierTag.getInt("TicksExisted"));
        });
        return optional;
    }

    public static void incrementTag(CompoundTag tag, String key, int amount, Predicate<Integer> predicate) {
        int value = tag.getInt(key);
        if (predicate.test(value)) {
            tag.putInt(key, value + amount);
        }
    }

    public static void incrementTag(Object owner, String key, int amount) {
        NBTHelper.incrementTag(owner, key, amount, (Integer tag) -> true);
    }

    public static int incrementTag(Object owner, String key, int amount, Predicate<Integer> predicate) {
        CompoundTag tag;
        Object object = owner;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Entity.class, ItemStack.class, BlockEntity.class, TempModifier.class}, (Object)object, n)) {
            case 0: {
                Entity entity = (Entity)object;
                tag = entity.getPersistentData();
                break;
            }
            case 1: {
                ItemStack stack = (ItemStack)object;
                tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
                break;
            }
            case 2: {
                BlockEntity blockEntity = (BlockEntity)object;
                tag = blockEntity.getPersistentData();
                break;
            }
            case 3: {
                TempModifier modifier = (TempModifier)object;
                tag = modifier.getNBT();
                break;
            }
            default: {
                return 0;
            }
        }
        int value = tag.getInt(key);
        if (predicate.test(value)) {
            tag.putInt(key, value + amount);
            if (owner instanceof ItemStack) {
                ItemStack stack = (ItemStack)owner;
                stack.set(DataComponents.CUSTOM_DATA, (Object)((CustomData)stack.get(DataComponents.CUSTOM_DATA)).update(tg -> tg.putInt(key, value + amount)));
            }
        }
        return value + amount;
    }

    public static CompoundTag getTagOrEmpty(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_DATA) ? ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag() : new CompoundTag();
    }

    public static CustomData getOrCreateTag(ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()));
        }
        return (CustomData)stack.get(DataComponents.CUSTOM_DATA);
    }

    public static void ensureTagAndDo(ItemStack stack, Consumer<CompoundTag> action) {
        CustomData nbt = NBTHelper.getOrCreateTag(stack);
        stack.set(DataComponents.CUSTOM_DATA, (Object)nbt.update(action));
    }

    public static <T extends Tag> T getOrPutTag(LivingEntity entity, String tag, T dfault) {
        CompoundTag data = entity.getPersistentData();
        if (!data.contains(tag) || data.get(tag).getId() != dfault.getId()) {
            data.put(tag, dfault);
        }
        return (T)data.get(tag);
    }

    public static String getTraitTagKey(Temperature.Trait trait) {
        return trait.getSerializedName();
    }

    @SubscribeEvent
    public static void convertTagsInContainer(PlayerContainerEvent.Open event) {
        NBTHelper.updateItemTags(event.getContainer().slots.stream().map(Slot::getItem).toList());
    }

    private static void updateItemTags(Collection<ItemStack> items) {
        for (ItemStack stack : items) {
            IntTag oldTemp;
            Item item = stack.getItem();
            if (!stack.has(DataComponents.CUSTOM_DATA)) {
                return;
            }
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (item == ModItems.SOULSPRING_LAMP.value()) {
                oldTemp = (IntTag)CSMath.orElse(tag.get("fuel"), tag.get("Fuel"));
                if (oldTemp == null) continue;
                stack.set(ModItemComponents.WATER_TEMPERATURE, (Object)oldTemp.getAsDouble());
                ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).update(tg -> {
                    tg.remove("fuel");
                    tg.remove("Fuel");
                });
                continue;
            }
            if (item != ModItems.FILLED_WATERSKIN.value() || (oldTemp = (DoubleTag)CSMath.orElse(tag.get("temperature"), tag.get("Temperature"))) == null) continue;
            stack.set(ModItemComponents.WATER_TEMPERATURE, (Object)oldTemp.getAsDouble());
            ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).update(tg -> {
                tg.remove("temperature");
                tg.remove("Temperature");
            });
        }
    }

    public static CompoundTag parseCompoundNbt(String tag) {
        if (tag.isBlank()) {
            return new CompoundTag();
        }
        try {
            return TagParser.parseTag((String)tag);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Error parsing compound tag \"{}\": {}", (Object)tag, (Object)e.getMessage());
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    public static ListTag listTagOf(List<?> list) {
        ListTag tag = new ListTag();
        for (Object obj : list) {
            if (obj instanceof Tag) {
                Tag tg = (Tag)obj;
                tag.add((Object)tg);
                continue;
            }
            tag.add((Object)NBTHelper.serialize(obj));
        }
        return tag;
    }

    @Nullable
    public static Object deserialize(Tag tag) {
        Tag tag2 = tag;
        Objects.requireNonNull(tag2);
        Tag tag3 = tag2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntTag.class, FloatTag.class, DoubleTag.class, LongTag.class, ShortTag.class, ByteTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class, StringTag.class, CompoundTag.class, ListTag.class}, (Object)tag3, n)) {
            case 0 -> {
                IntTag integer = (IntTag)tag3;
                yield integer.getAsInt();
            }
            case 1 -> {
                FloatTag floating = (FloatTag)tag3;
                yield Float.valueOf(floating.getAsFloat());
            }
            case 2 -> {
                DoubleTag doubleTag = (DoubleTag)tag3;
                yield doubleTag.getAsDouble();
            }
            case 3 -> {
                LongTag longTag = (LongTag)tag3;
                yield longTag.getAsLong();
            }
            case 4 -> {
                ShortTag shortTag = (ShortTag)tag3;
                yield shortTag.getAsShort();
            }
            case 5 -> {
                ByteTag byteTag = (ByteTag)tag3;
                yield byteTag.getAsByte();
            }
            case 6 -> {
                ByteArrayTag byteArray = (ByteArrayTag)tag3;
                yield byteArray.getAsString();
            }
            case 7 -> {
                IntArrayTag intArray = (IntArrayTag)tag3;
                yield intArray.getAsIntArray();
            }
            case 8 -> {
                LongArrayTag longArray = (LongArrayTag)tag3;
                yield longArray.getAsLongArray();
            }
            case 9 -> {
                StringTag string = (StringTag)tag3;
                yield string.getAsString();
            }
            case 10 -> {
                CompoundTag compound = (CompoundTag)tag3;
                if (compound.contains("value") && compound.contains("class")) {
                    yield NBTHelper.tryReadEnum(compound);
                }
                yield null;
            }
            case 11 -> {
                ListTag list = (ListTag)tag3;
                yield list.stream().map(NBTHelper::deserialize).toList();
            }
            default -> null;
        };
    }

    @Nullable
    private static <T extends Enum<T>> Enum<T> tryReadEnum(CompoundTag tag) {
        try {
            Class<?> clazz = Class.forName(tag.getString("class"));
            return Enum.valueOf(clazz, tag.getString("value"));
        }
        catch (ClassNotFoundException e) {
            ColdSweat.LOGGER.error("Failed to read enum from compound tag: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static Tag serialize(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Double.class, Long.class, Short.class, Byte.class, String.class, List.class, Enum.class}, (Object)object2, n)) {
            case 0 -> {
                Integer integer = (Integer)object2;
                yield IntTag.valueOf((int)integer);
            }
            case 1 -> {
                Float floating = (Float)object2;
                yield FloatTag.valueOf((float)floating.floatValue());
            }
            case 2 -> {
                Double doubleTag = (Double)object2;
                yield DoubleTag.valueOf((double)doubleTag);
            }
            case 3 -> {
                Long longTag = (Long)object2;
                yield LongTag.valueOf((long)longTag);
            }
            case 4 -> {
                Short shortTag = (Short)object2;
                yield ShortTag.valueOf((short)shortTag);
            }
            case 5 -> {
                Byte byteTag = (Byte)object2;
                yield ByteTag.valueOf((byte)byteTag);
            }
            case 6 -> {
                String string = (String)object2;
                yield StringTag.valueOf((String)string);
            }
            case 7 -> {
                List list = (List)object2;
                ListTag tag = new ListTag();
                for (Object item : list) {
                    Tag itemTag = NBTHelper.serialize(item);
                    if (itemTag == null) continue;
                    tag.add((Object)itemTag);
                }
                yield tag;
            }
            case 8 -> {
                final Enum enm = (Enum)object2;
                yield new CompoundTag(){
                    {
                        this.putString("value", enm.name());
                        this.putString("class", enm.getClass().getName());
                    }
                };
            }
            default -> null;
        };
    }
}

