/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class TempEffect {
    private final LivingEntity entity;
    private final IntegerBounds bounds;
    private final TempEffectType<?> type;

    public TempEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds range) {
        this.type = type;
        this.entity = entity;
        this.bounds = range;
    }

    public abstract Side getSide();

    public TempEffectType<?> type() {
        return this.type;
    }

    protected LivingEntity entity() {
        return this.entity;
    }

    protected IntegerBounds bounds() {
        return this.bounds;
    }

    protected boolean test(Entity entity) {
        return Objects.equals(this.entity, entity) && this.bounds().test(Math.round((float)CSMath.clamp(this.getTemperature(), -100.0, 100.0)));
    }

    protected double getTemperature() {
        return this.entity.f_19853_.f_46443_ ? Overlays.BLEND_BODY_TEMP : Temperature.get(this.entity, Temperature.Trait.BODY);
    }

    protected double getEffectFactor() {
        if (EntityTempManager.isImmuneToTemperature(this.entity)) {
            return 0.0;
        }
        double temperature = this.getTemperature();
        double minTemp = this.bounds().min();
        double maxTemp = this.bounds().max();
        double resistance = EntityTempManager.getResistance(temperature, this.entity);
        temperature = CSMath.blend(temperature, minTemp, resistance, 0.0, 1.0);
        return CSMath.blend(0.0, 1.0, temperature, minTemp, maxTemp);
    }

    public static enum Side {
        CLIENT,
        SERVER,
        COMMON;


        public boolean checkSide(boolean isClient) {
            return this == CLIENT && isClient || this == SERVER && !isClient || this == COMMON;
        }
    }
}

