/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class CyclingSlotBackground {
    private static final int ICON_CHANGE_TICK_RATE = 30;
    private static final int ICON_SIZE = 16;
    private static final int ICON_TRANSITION_TICK_DURATION = 4;
    private final int slotIndex;
    private final List<ResourceLocation> icons;
    private int tick;
    private int iconIndex;

    public CyclingSlotBackground(int slotIndex, List<ResourceLocation> icons) {
        this.slotIndex = slotIndex;
        this.icons = icons;
    }

    public void tick() {
        if (!this.icons.isEmpty() && ++this.tick % 30 == 0) {
            this.iconIndex = (this.iconIndex + 1) % this.icons.size();
        }
    }

    public void render(AbstractContainerMenu menu, PoseStack poseStack, float partialTick, int guiLeft, int guiTop) {
        Slot slot = menu.m_38853_(this.slotIndex);
        if (!this.icons.isEmpty() && !slot.m_6657_()) {
            float transparency;
            boolean shouldTransition = this.icons.size() > 1 && this.tick >= 30;
            float f = transparency = shouldTransition ? this.getIconTransitionTransparency(partialTick) : 1.0f;
            if (transparency < 1.0f) {
                int iconIndex = Math.floorMod(this.iconIndex - 1, this.icons.size());
                this.renderIcon(slot, this.icons.get(iconIndex), 1.0f - transparency, poseStack, guiLeft, guiTop);
            }
            this.renderIcon(slot, this.icons.get(this.iconIndex), transparency, poseStack, guiLeft, guiTop);
        }
    }

    private void renderIcon(Slot slot, ResourceLocation icon, float alpha, PoseStack poseStack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        AbstractContainerScreen.m_93133_((PoseStack)poseStack, (int)(x + slot.f_40220_), (int)(y + slot.f_40221_), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    private float getIconTransitionTransparency(float partialTick) {
        float $$1 = (float)(this.tick % 30) + partialTick;
        return Math.min($$1, 4.0f) / 4.0f;
    }
}

