/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.common.item.ChameleonArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChameleonArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    public static final ResourceLocation GREEN_LAYER_1_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_1.png");
    public static final ResourceLocation GREEN_LAYER_2_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_2.png");
    public static final ResourceLocation RED_LAYER_1_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_1_red.png");
    public static final ResourceLocation RED_LAYER_2_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_2_red.png");
    public static final ResourceLocation BLUE_LAYER_1_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_1_blue.png");
    public static final ResourceLocation BLUE_LAYER_2_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_2_blue.png");

    public ChameleonArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer, null, null);
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.CHEST, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.LEGS, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.FEET, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.HEAD, light);
    }

    protected void renderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, T livingEntity, EquipmentSlot slot, int light) {
        ItemStack itemstack = livingEntity.m_6844_(slot);
        Item item = itemstack.m_41720_();
        if (item instanceof ChameleonArmorItem) {
            ChameleonArmorItem armorItem = (ChameleonArmorItem)item;
            if (Mob.m_147233_((ItemStack)itemstack) == slot) {
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                boolean isInnerModel = this.m_117128_(slot);
                HumanoidModel<?> model = ChameleonArmorItem.Client.getRealArmorModel(livingEntity, itemstack, slot);
                ((HumanoidModel)this.m_117386_()).m_102872_(model);
                this.setPartVisibilities(model, slot);
                this.renderModel(poseStack, buffer, light, armorItem, (Model)model, isInnerModel, 1.0f, 1.0f, 1.0f, 1.0f, Color.GREEN.getLayer(slot));
                double adaptiveFactor = AdaptiveInsulation.getFactorFromArmor(itemstack);
                ResourceLocation overlay = adaptiveFactor < 0.0 ? Color.BLUE.getLayer(slot) : Color.RED.getLayer(slot);
                float alpha = (float)Math.abs(adaptiveFactor);
                this.renderModel(poseStack, buffer, light, armorItem, (Model)model, isInnerModel, 1.0f, 1.0f, 1.0f, alpha, overlay);
                if (itemstack.m_41790_()) {
                    this.renderGlint(poseStack, buffer, light, (Model)model);
                }
                RenderSystem.m_69461_();
            }
        }
    }

    protected boolean m_117128_(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }

    protected void renderModel(PoseStack poseStack, MultiBufferSource buffer, int light, ArmorItem armorItem, Model model, boolean showGlint, float red, float green, float blue, float alpha, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)armorResource));
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, red, green, blue, alpha);
    }

    protected void renderGlint(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Model model) {
        model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110484_()), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void setPartVisibilities(HumanoidModel<T> pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                pModel.f_102808_.f_104207_ = true;
                pModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102811_.f_104207_ = true;
                pModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
            }
        }
    }

    public static enum Color {
        GREEN(GREEN_LAYER_1_LOCATION, GREEN_LAYER_2_LOCATION),
        RED(RED_LAYER_1_LOCATION, RED_LAYER_2_LOCATION),
        BLUE(BLUE_LAYER_1_LOCATION, BLUE_LAYER_2_LOCATION);

        private final ResourceLocation layer1;
        private final ResourceLocation layer2;

        private Color(ResourceLocation layer1, ResourceLocation layer2) {
            this.layer1 = layer1;
            this.layer2 = layer2;
        }

        public ResourceLocation getLayer1() {
            return this.layer1;
        }

        public ResourceLocation getLayer2() {
            return this.layer2;
        }

        public ResourceLocation getLayer(EquipmentSlot slot) {
            return slot == EquipmentSlot.LEGS ? this.layer2 : this.layer1;
        }
    }
}

