/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.block.BoilerBlock;
import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class HearthBottomBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty COOLING = BooleanProperty.m_61465_((String)"cooling");
    public static final BooleanProperty HEATING = BooleanProperty.m_61465_((String)"heating");
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty FROSTED = BooleanProperty.m_61465_((String)"frosted");
    public static final BooleanProperty SMART = BooleanProperty.m_61465_((String)"smart");

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_155954_(2.0f).m_155956_(10.0f).m_60999_().m_60924_((state, level, pos) -> false).m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 13 : 0).m_60955_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(1);
    }

    public HearthBottomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)COOLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEATING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FROSTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SMART, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.HEARTH ? HearthBlockEntity::tickSelf : null;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HearthBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HearthBlockEntity) {
            HearthBlockEntity te = (HearthBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (player.m_21120_(hand).m_41720_() == Items.f_42446_) {
                int hearthFuel;
                Vec3 clickedPos = rayTraceResult.m_82450_();
                Vec3i lavaSideOffset = ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122436_();
                Vec3 lavaSidePos = CSMath.getCenterPos(pos).m_82520_((double)lavaSideOffset.m_123341_() * 0.65, (double)lavaSideOffset.m_123342_() * 0.65, (double)lavaSideOffset.m_123343_() * 0.65);
                Vec3i waterSideOffset = ((Direction)state.m_61143_((Property)FACING)).m_122428_().m_122436_();
                Vec3 waterSidePos = CSMath.getCenterPos(pos).m_82520_((double)waterSideOffset.m_123341_() * 0.65, (double)waterSideOffset.m_123342_() * 0.65, (double)waterSideOffset.m_123343_() * 0.65);
                boolean isLava = clickedPos.m_82554_(lavaSidePos) < clickedPos.m_82554_(waterSidePos);
                Vec3 sidePos = isLava ? lavaSidePos : waterSidePos;
                BucketItem filledBucket = isLava ? (BucketItem)Items.f_42448_ : (BucketItem)Items.f_42447_;
                int itemFuel = Math.abs(te.getItemFuel(filledBucket.m_7968_()));
                int n = hearthFuel = isLava ? te.getHotFuel() : te.getColdFuel();
                if ((double)hearthFuel >= (double)itemFuel * 0.99 && rayTraceResult.m_82450_().m_82554_(sidePos) < 0.4 && itemFuel > 0) {
                    if (isLava) {
                        te.setHotFuel(hearthFuel - itemFuel);
                    } else {
                        te.setColdFuel(hearthFuel - itemFuel);
                    }
                    stack.m_41774_(1);
                    player.m_36356_(filledBucket.m_7968_());
                    level.m_5594_(null, pos, (SoundEvent)filledBucket.getFluid().m_142520_().get(), SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
                    return InteractionResult.SUCCESS;
                }
                if (!level.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)te, (BlockPos)pos);
                }
            } else {
                int hearthFuel;
                int itemFuel = te.getItemFuel(stack);
                int n = hearthFuel = itemFuel > 0 ? te.getHotFuel() : te.getColdFuel();
                if (itemFuel != 0 && (double)hearthFuel + (double)Math.abs(itemFuel) * 0.75 < (double)te.getMaxFuel()) {
                    if (!player.m_7500_()) {
                        if (stack.hasCraftingRemainingItem()) {
                            ItemStack container = stack.getCraftingRemainingItem();
                            player.m_21008_(hand, container);
                        } else {
                            stack.m_41774_(1);
                        }
                    }
                    te.addFuel(itemFuel);
                    level.m_5594_(null, pos, itemFuel > 0 ? SoundEvents.f_11780_ : SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
                } else if (!level.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)te, (BlockPos)pos);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        HearthBlockEntity hearth = (HearthBlockEntity)level.m_7702_(pos);
        if (hearth != null && hearth.isUsingColdFuel()) {
            IceboxBlock.createMistParticles(level, pos);
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            BoilerBlock.createFlameParticles(level, pos, state, 0.6, 0.1);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState lastState, boolean p_60570_) {
        level.m_7731_(pos.m_7494_(), WorldHelper.waterlog(ModBlocks.HEARTH_TOP.m_49966_(), level, pos.m_7494_()), 3);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, neighborBlock, fromPos, isMoving);
        if (level.m_8055_(pos.m_7494_()).m_60734_() != ModBlocks.HEARTH_TOP) {
            level.m_46961_(pos, false);
        } else {
            HearthBlockEntity hearth = (HearthBlockEntity)level.m_7702_(pos);
            if (hearth != null) {
                hearth.checkInputSignal();
                hearth.checkForStateChange();
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (state.m_60734_() != newState.m_60734_() && !isMoving && (tileentity = level.m_7702_(pos)) instanceof HearthBlockEntity) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((HearthBlockEntity)tileentity));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, COOLING, HEATING, LIT, FROSTED, SMART});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        return level.m_8055_(context.m_8083_().m_7494_()).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)SMART, (Comparable)ConfigSettings.SMART_HEARTH.get()) : null;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.m_122434_() != Direction.Axis.Y && direction != ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }
}

