/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.ColdSweat;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TaskScheduler {
    private static final List<QueueEntry> SERVER_SCHEDULE = new ArrayList<QueueEntry>(32);
    private static final List<QueueEntry> CLIENT_SCHEDULE = new ArrayList<QueueEntry>(32);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static synchronized void runScheduledTasks(TickEvent event) {
        List<QueueEntry> schedule;
        if (!(event instanceof TickEvent.ServerTickEvent) && !(event instanceof TickEvent.ClientTickEvent) || event.phase != TickEvent.Phase.START) return;
        List<QueueEntry> list = schedule = event.side.isClient() ? CLIENT_SCHEDULE : SERVER_SCHEDULE;
        if (schedule.isEmpty()) return;
        for (int i = 0; i < schedule.size(); ++i) {
            QueueEntry entry = schedule.get(i);
            int ticks = entry.time;
            if (ticks <= 0) {
                try {
                    entry.task.run();
                }
                catch (Exception e) {
                    ColdSweat.LOGGER.error("Error while running scheduled task", (Throwable)e);
                    throw e;
                }
                schedule.remove(i);
                --i;
                continue;
            }
            entry.time = ticks - 1;
        }
    }

    public static void scheduleServer(Runnable task, int delay) {
        SERVER_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void scheduleClient(Runnable task, int delay) {
        CLIENT_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void schedule(Runnable task, int delay) {
        TaskScheduler.scheduleServer(task, delay);
        TaskScheduler.scheduleClient(task, delay);
    }

    static class QueueEntry {
        private final Runnable task;
        private int time;

        public QueueEntry(Runnable task, int time) {
            this.task = task;
            this.time = time;
        }
    }
}

