/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class AbstractVignetteEffect
extends TempEffect {
    public AbstractVignetteEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    protected abstract ResourceLocation getTexture();

    protected abstract Vector4f getColor(float var1);

    protected void setupRender(float opacity, float tickTime) {
        Vector4f color = this.getColor(tickTime);
        RenderSystem.color4f((float)color.func_195910_a(), (float)color.func_195913_b(), (float)color.func_195914_c(), (float)(opacity * color.func_195915_d()));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture());
    }

    protected void render(float opacity, float tickTime, RenderGameOverlayEvent.Pre event) {
        double width = event.getWindow().func_198109_k();
        double height = event.getWindow().func_198091_l();
        double scale = event.getWindow().func_198100_s();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.setupRender(opacity, tickTime);
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tesselator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, height / scale, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(width / scale, height / scale, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(width / scale, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tesselator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void vignette(RenderGameOverlayEvent.Pre event) {
        if (!this.test((Entity)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        LivingEntity entity = this.entity();
        float effect = (float)this.getEffectFactor();
        float tickTime = (float)entity.field_70173_aa + event.getPartialTicks();
        if (event.getType() == RenderGameOverlayEvent.ElementType.VIGNETTE) {
            float opacity = CSMath.blend(0.0f, 1.0f, effect, 0.0f, 1.0f);
            if (opacity == 0.0f) {
                return;
            }
            this.render(opacity, tickTime, event);
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

