/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class ElevationTempModifier
extends TempModifier {
    public ElevationTempModifier() {
        this(49);
    }

    public ElevationTempModifier(int samples) {
        this.getNBT().func_74768_a("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        World level = entity.field_70170_p;
        DimensionTempData dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get(entity.field_70170_p.func_241828_r()).get(level.func_230315_m_());
        if (dimTempOverride != null) {
            return temp -> temp;
        }
        if (level.func_230315_m_().func_236037_d_()) {
            return temp -> temp;
        }
        ArrayList<Pair> depthTable = new ArrayList<Pair>();
        for (BlockPos pos : WorldHelper.getPositionGrid(entity.func_233580_cy_(), this.getNBT().func_74762_e("Samples"), 10)) {
            depthTable.add(Pair.of((Object)pos, (Object)CSMath.getDistance((Vector3i)entity.func_233580_cy_(), (Vector3i)pos)));
        }
        BlockPos translatedPos = CompatManager.isValkyrienSkiesLoaded() ? CompatManager.Valkyrien.transformIfShipPos(level, entity.func_233580_cy_()) : entity.func_233580_cy_();
        int normalSkylight = entity.field_70170_p.func_226658_a_(LightType.SKY, entity.func_233580_cy_());
        int translatedSkylight = entity.field_70170_p.func_226658_a_(LightType.SKY, translatedPos);
        int skylight = Math.min(normalSkylight, translatedSkylight);
        ArrayList<Pair> depthRegions = new ArrayList<Pair>(depthTable.size());
        block1: for (Pair pair : depthTable) {
            int groundLevel;
            int minY;
            BlockPos originalPos = (BlockPos)pair.getFirst();
            int originalY = originalPos.func_177956_o();
            int adjustedY = CSMath.betweenInclusive(originalY, minY = 0, groundLevel = WorldHelper.getHeight(originalPos, level, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES)) ? CSMath.clamp(originalY + skylight - 4, minY, groundLevel) : (originalY >= groundLevel ? CSMath.clamp(originalY + skylight - 4, groundLevel, originalY) : CSMath.clamp(originalY + skylight - 4, originalY, minY));
            BlockPos pos = new BlockPos(originalPos.func_177958_n(), adjustedY, originalPos.func_177952_p());
            double distance = (Double)pair.getSecond();
            for (DepthTempData data : ConfigSettings.DEPTH_REGIONS.get()) {
                DepthTempData.TempRegion region = data.getRegion(level, pos);
                if (region == null) continue;
                int regionMax = region.top().getHeight(pos, level);
                int regionMin = region.bottom().getHeight(pos, level);
                depthRegions.add(Pair.of((Object)pos, (Object)new RegionEntry(region, distance, regionMin, regionMax)));
                continue block1;
            }
            depthRegions.add(Pair.of((Object)pos, (Object)new RegionEntry(null, distance, 0, 0)));
        }
        return temp -> {
            ArrayList<Pair> depthTemps = new ArrayList<Pair>();
            for (Pair entry : depthRegions) {
                BlockPos pos = (BlockPos)entry.getFirst();
                RegionEntry regionEntry = (RegionEntry)entry.getSecond();
                DepthTempData.TempRegion region = regionEntry.region();
                if (region == null) continue;
                double distance = regionEntry.distance();
                int maxY = regionEntry.maxY();
                int minY = regionEntry.minY();
                double depthTemp = region.getTemperature((double)temp, pos, level, maxY, minY);
                double weight = 1.0 / (distance / 10.0 + 1.0);
                depthTemps.add(new Pair((Object)depthTemp, (Object)weight));
            }
            if (depthTemps.isEmpty()) {
                return temp;
            }
            return CSMath.weightedAverage(depthTemps);
        };
    }

    private static final class RegionEntry {
        private final DepthTempData.TempRegion region;
        private final double distance;
        private final int minY;
        private final int maxY;

        private RegionEntry(DepthTempData.TempRegion region, double distance, int minY, int maxY) {
            this.region = region;
            this.distance = distance;
            this.minY = minY;
            this.maxY = maxY;
        }

        public DepthTempData.TempRegion region() {
            return this.region;
        }

        public double distance() {
            return this.distance;
        }

        public int minY() {
            return this.minY;
        }

        public int maxY() {
            return this.maxY;
        }
    }
}

