/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class EntityClimateTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (!ConfigSettings.ENTITY_CLIMATES.get().containsKey((Object)entity.func_200600_R())) {
            this.expires(0);
            return temp -> temp;
        }
        EntityClimateData climateData = ConfigHelper.getFirstOrNull(ConfigSettings.ENTITY_CLIMATES, entity.func_200600_R(), data -> data.test((Entity)entity));
        if (climateData != null && climateData.test((Entity)entity)) {
            switch (trait) {
                case WORLD: {
                    double worldTemp = WorldHelper.getRoughTemperatureAt(entity.field_70170_p, entity.func_233580_cy_(), 1);
                    return temp -> temp + worldTemp;
                }
                case BURNING_POINT: {
                    return temp -> temp + climateData.getMaxOffset();
                }
                case FREEZING_POINT: {
                    return temp -> temp + climateData.getMinOffset();
                }
            }
        }
        return temp -> temp;
    }
}

