/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;

public class SimpleTempModifier
extends TempModifier {
    public SimpleTempModifier() {
        this(0.0, Operation.ADD);
    }

    public SimpleTempModifier(double temperature, Operation operation) {
        this.setTemperature(temperature);
        this.setOperation(operation);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        return temp -> this.getOperation().apply((double)temp, this.getTemperature());
    }

    @Override
    public void markDirty() {
        super.markDirty();
    }

    public double getTemperature() {
        return this.getNBT().func_74769_h("Temperature");
    }

    public void setTemperature(double temperature) {
        this.getNBT().func_74780_a("Temperature", temperature);
        this.markDirty();
    }

    public Operation getOperation() {
        return Operation.byName(this.getNBT().func_74779_i("Operation"));
    }

    public void setOperation(Operation operation) {
        this.getNBT().func_74778_a("Operation", operation.func_176610_l());
        this.markDirty();
    }

    public static enum Operation implements StringRepresentable
    {
        ADD("add", (temp, val) -> temp + val),
        SUBTRACT("subtract", (temp, val) -> temp - val),
        MULTIPLY("multiply", (temp, val) -> temp * val),
        DIVIDE("divide", (temp, val) -> val == 0.0 ? temp : temp / val),
        POWER("power", Math::pow),
        ROOT("root", (temp, val) -> val == 0.0 ? temp : Math.pow(temp, 1.0 / val)),
        SET("set", (temp, val) -> val),
        MAX("max", Math::max),
        MIN("min", Math::min);

        private final BiFunction<Double, Double, Double> function;
        private final String name;

        private Operation(String name, BiFunction<Double, Double, Double> function) {
            this.name = name;
            this.function = function;
        }

        public BiFunction<Double, Double, Double> function() {
            return this.function;
        }

        public double apply(double temp, double value) {
            return this.function.apply(temp, value);
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Operation byName(String name) {
            return (Operation)EnumHelper.byName((Enum[])Operation.values(), (String)name);
        }
    }
}

