/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.api.event.client.InsulatorTabBuildEvent;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FilterInsulationItemsTab {
    @SubscribeEvent
    public static void filterItems(InsulatorTabBuildEvent event) {
        event.addCheck((item, insulator) -> {
            ITag tagKey;
            HashMap<ITag<Item>, Set<Item>> tagItems = new HashMap<ITag<Item>, Set<Item>>();
            for (ItemRequirement itemRequirement : insulator.item().requirements()) {
                for (Either<ITag<Item>, Item> either : itemRequirement.items().requirements()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (ITag)either.left().get();
                    FilterInsulationItemsTab.mapAdd(tagItems, (ITag<Item>)tagKey);
                }
                for (Either<ITag<Item>, Item> either : itemRequirement.items().exclusions()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (ITag)either.left().get();
                    FilterInsulationItemsTab.mapRemove(tagItems, (ITag<Item>)tagKey);
                }
            }
            for (ItemRequirement itemRequirement : insulator.item().exclusions()) {
                for (Either<ITag<Item>, Item> either : itemRequirement.items().requirements()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (ITag)either.left().get();
                    FilterInsulationItemsTab.mapRemove(tagItems, (ITag<Item>)tagKey);
                }
                for (Either<ITag<Item>, Item> either : itemRequirement.items().exclusions()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (ITag)either.left().get();
                    FilterInsulationItemsTab.mapAdd(tagItems, (ITag<Item>)tagKey);
                }
            }
            for (Map.Entry entry : tagItems.entrySet()) {
                int tagSize;
                ITag tagKey2 = (ITag)entry.getKey();
                if (!tagKey2.func_230235_a_(item) || (tagSize = ((Set)entry.getValue()).size()) <= 6 || tagKey2.func_230236_b_().stream().findFirst().get() == item) continue;
                return false;
            }
            return true;
        });
    }

    private static void mapAdd(Map<ITag<Item>, Set<Item>> map, ITag<Item> tag) {
        Set items = map.computeIfAbsent(tag, k -> new HashSet(RegistryHelper.mapTaggableList(new NegatableList(Either.left((Object)tag)))));
        Set currentItems = map.computeIfAbsent(tag, k -> new HashSet());
        currentItems.addAll(items);
        map.put(tag, currentItems);
    }

    private static void mapRemove(Map<ITag<Item>, Set<Item>> map, ITag<Item> tag) {
        Set items = map.computeIfAbsent(tag, k -> new HashSet(RegistryHelper.mapTaggableList(new NegatableList(Either.left((Object)tag)))));
        for (Set<Item> itemSet : map.values()) {
            itemSet.removeAll(items);
        }
    }
}

