/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2f;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import com.momosoftworks.coldsweat.util.serialization.Triplet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vec2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vec2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;
    private static int LEFT_DROPLETS = 0;
    private static int RIGHT_DROPLETS = 0;
    private static final int MAX_DROPLETS = 5;

    @SubscribeEvent
    public static void updateSkyBrightness(TickEvent.ClientTickEvent event) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level != null) {
            level.func_72966_v();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        float alpha;
        Object pos;
        int i;
        boolean justExitedWater;
        ClientPlayerEntity player;
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || !ConfigSettings.WATER_EFFECT_SETTING.get().showGui()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack ps = event.getMatrixStack();
        float frametime = mc.func_193989_ak();
        int screenWidth = mc.func_228018_at_().func_198107_o();
        int screenHeight = mc.func_228018_at_().func_198087_p();
        boolean paused = mc.func_147113_T();
        int uiScale = mc.field_71474_y.field_74335_Z;
        if (uiScale == 0) {
            uiScale = mc.func_228018_at_().func_216521_a(0, mc.func_211821_e());
        }
        if ((player = mc.field_71439_g) == null || player.func_175149_v()) {
            return;
        }
        BlockPos playerPos = new BlockPos(player.func_174824_e(1.0f));
        float playerYVelocity = (float)(player.func_213303_ch().field_72448_b - player.field_70137_T);
        boolean isSubmerged = player.func_208600_a((ITag)FluidTags.field_206959_a);
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        double midTemp = (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0;
        float tempMult = (float)CSMath.blend(1.0, 3.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), midTemp, ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add(new Vec2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.field_71439_g, Temperature.Trait.WORLD, WaterTempModifier.class).map(arg_0 -> WetnessRenderer.lambda$onRenderOverlay$0((PlayerEntity)player, arg_0)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater) {
            for (int i2 = 0; i2 < 10; ++i2) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)(Math.sin(i2 * 4 + player.field_70173_aa) / 2.0 + 0.5) * (float)screenHeight;
                newDrop.position.x = (float)((double)i2 / 10.0) * (float)screenWidth;
                WATER_DROPS.add(newDrop);
            }
        }
        boolean bl2 = WAS_SUBMERGED = player.func_70089_S() && isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f) && WATER_DROPS.size() < 5) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth));
        }
        int waterColor = BiomeColors.func_228363_c_((IBlockDisplayReader)player.field_70170_p, (BlockPos)playerPos);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WATER_DROP);
        MatrixStack poseStack = event.getMatrixStack();
        poseStack.func_227860_a_();
        int blockLight = player.field_70170_p.func_225524_e_().func_215569_a(LightType.BLOCK).func_215611_b(playerPos);
        int skyLight = player.field_70170_p.func_225524_e_().func_215569_a(LightType.SKY).func_215611_b(playerPos);
        int combinedLight = LightTexture.func_228451_a_((int)blockLight, (int)skyLight);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WATER_DROP);
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        for (i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            pos = drop.position;
            alpha = drop.alpha;
            drop.size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(drop.size);
            int scaledSize = drop.size / uiScale * 3;
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, buffer, (int)CSMath.roundNearest(((Vec2f)pos).x, 3.0f / (float)uiScale), (int)((Vec2f)pos).y, scaledSize, scaledSize, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)((Vec2f)pos).y;
                    if (!isSubmerged) {
                        drop.position.add(new Vec2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div(uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(((Vec2f)pos).y - (float)oldY)); ++j) {
                        TRAILS.add(new Triplet<Vec2i, Float, Integer>(new Vec2i((int)((Vec2f)pos).x, oldY + j), Float.valueOf(alpha), drop.size));
                    }
                }
                if (((Vec2f)pos).x < -20.0f) {
                    ((Vec2f)pos).x = screenWidth + 20;
                } else if (((Vec2f)pos).x > (float)(screenWidth + 20)) {
                    ((Vec2f)pos).x = -20.0f;
                }
                if (!(((Vec2f)pos).y > (float)screenHeight)) continue;
                WetnessRenderer.removeDrop(drop);
                --i;
                continue;
            }
            WetnessRenderer.removeDrop(drop);
            --i;
        }
        tesselator.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WATER_DROP_TRAIL);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        for (i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vec2i, Float, Integer> trail = TRAILS.get(i);
            pos = trail.getA();
            alpha = trail.getB().floatValue();
            int size = trail.getC();
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, buffer, (int)CSMath.roundNearest(((Vec2i)pos).x, 3.0f / (float)uiScale * 4.0f), ((Vec2i)pos).y, size / uiScale * 3, 1, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (paused) continue;
                alpha = wetness <= 0.0 ? (alpha -= 0.08f * frametime) : (alpha -= 0.045f * frametime * tempMult / 2.0f);
                TRAILS.set(i, new Triplet<Vec2i, Float, Integer>(new Vec2i(((Vec2i)pos).x, ((Vec2i)pos).y), Float.valueOf(alpha), size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        tesselator.func_78381_a();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        poseStack.func_227865_b_();
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth) {
        int x;
        Droplet.Side side;
        IntegerBounds dropSize = ConfigSettings.WATER_DROPLET_SCALE.get();
        int size = dropSize.getRandom();
        Droplet.Side side2 = side = Math.random() < 0.5 ? Droplet.Side.LEFT : Droplet.Side.RIGHT;
        if (WetnessRenderer.getDropletsOnSide(side) > WetnessRenderer.getDropletsOnSide(side.opposite())) {
            side = side.opposite();
        }
        int xOffset = (int)(Math.random() * (double)screenWidth / 4.0);
        int n = x = side == Droplet.Side.LEFT ? xOffset : screenWidth - xOffset;
        if (side == Droplet.Side.LEFT) {
            ++LEFT_DROPLETS;
        } else {
            ++RIGHT_DROPLETS;
        }
        return new Droplet(new Vec2f(x, -size), 1.0f, size, side);
    }

    private static void removeDrop(Droplet droplet) {
        if (droplet.side == Droplet.Side.LEFT) {
            --LEFT_DROPLETS;
        } else {
            --RIGHT_DROPLETS;
        }
        WATER_DROPS.remove(droplet);
    }

    private static int getDropletsOnSide(Droplet.Side side) {
        return side == Droplet.Side.LEFT ? LEFT_DROPLETS : RIGHT_DROPLETS;
    }

    private static void renderQuadDirect(MatrixStack poseStack, BufferBuilder buffer, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float alpha, int lightLevel, int waterColor) {
        alpha = (float)((double)alpha * ConfigSettings.WATER_DROPLET_OPACITY.get());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        Matrix4f lastPose = poseStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(lastPose, (float)x, (float)y, 0.0f).func_225583_a_(u, v).func_227885_a_(red, green, blue, alpha).func_227886_a_(lightLevel).func_181675_d();
        buffer.func_227888_a_(lastPose, (float)x, (float)(y + height), 0.0f).func_225583_a_(u, v + vHeight).func_227885_a_(red, green, blue, alpha).func_227886_a_(lightLevel).func_181675_d();
        buffer.func_227888_a_(lastPose, (float)(x + width), (float)(y + height), 0.0f).func_225583_a_(u + uWidth, v + vHeight).func_227885_a_(red, green, blue, alpha).func_227886_a_(lightLevel).func_181675_d();
        buffer.func_227888_a_(lastPose, (float)(x + width), (float)y, 0.0f).func_225583_a_(u + uWidth, v).func_227885_a_(red, green, blue, alpha).func_227886_a_(lightLevel).func_181675_d();
    }

    private static /* synthetic */ Double lambda$onRenderOverlay$0(PlayerEntity player, WaterTempModifier mod) {
        return CSMath.blend(0.0, 1.0, mod.getTemperature(), 0.0, mod.getTargetTemperature((LivingEntity)player));
    }

    static /* synthetic */ float access$000(float x0) {
        return WetnessRenderer.getRandomVelocity(x0);
    }

    protected static class Droplet {
        public Vec2f position;
        public float alpha;
        public int size;
        public float yMotion = WetnessRenderer.access$000(Minecraft.func_71410_x().func_184121_ak() / 5.0f);
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;
        public Side side;

        public Droplet(Vec2f position, float alpha, int size, Side side) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
            this.side = side;
        }

        public static enum Side {
            LEFT,
            RIGHT;


            public Side opposite() {
                return this == LEFT ? RIGHT : LEFT;
            }
        }
    }
}

