/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.gui.config.AbstractConfigPage;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.DisableHearthParticlesMessage;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public abstract class AbstractHearthScreen<T extends Container>
extends DisplayEffectsScreen<T> {
    private static final ResourceLocation HEARTH_GUI = new ResourceLocation("cold_sweat", "textures/gui/screen/hearth_gui.png");
    ImageButton particleButton = null;
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of((Object)this.getBlockEntity().func_174877_v(), (Object)this.getBlockEntity().func_145831_w().func_234923_W_().func_240901_a_());
    boolean hideParticles;
    boolean hideParticlesOld = this.hideParticles = HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);

    abstract HearthBlockEntity getBlockEntity();

    public AbstractHearthScreen(T screenContainer, PlayerInventory inv, ITextComponent title) {
        super(screenContainer, inv, title);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.getBlockEntity().hasSmokestack()) {
            this.particleButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 160, this.field_147009_r + 8, 8, 7, 176 + (!this.hideParticles ? 0 : 8), 14, 7, HEARTH_GUI, button -> {
                boolean bl = this.hideParticles = !this.hideParticles;
                if (this.hideParticles) {
                    HearthSaveDataHandler.DISABLED_HEARTHS.add(this.levelPos);
                    if (HearthSaveDataHandler.DISABLED_HEARTHS.size() > 64) {
                        HearthSaveDataHandler.DISABLED_HEARTHS.remove(HearthSaveDataHandler.DISABLED_HEARTHS.iterator().next());
                    }
                } else {
                    HearthSaveDataHandler.DISABLED_HEARTHS.remove(this.levelPos);
                }
                AbstractConfigPage.setButtonImageX((ImageButton)button, 176 + (!this.hideParticles ? 0 : 8));
            }){

                public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                    if (this.field_230693_o_ && this.field_230694_p_ && this.func_230987_a_(button) && this.func_230992_c_(mouseX, mouseY)) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187839_fV, (float)(!AbstractHearthScreen.this.hideParticles ? 1.5f : 1.9f), (float)0.75f));
                        this.func_230982_a_(mouseX, mouseY);
                        return true;
                    }
                    return false;
                }

                public void func_230443_a_(MatrixStack poseStack, int mouseX, int mouseY) {
                    AbstractHearthScreen.this.func_243308_b(poseStack, Arrays.asList(new TranslationTextComponent("cold_sweat.screen.hearth.show_particles")), mouseX, mouseY);
                }
            });
        }
    }

    public void func_230430_a_(MatrixStack ps, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ps);
        super.func_230430_a_(ps, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ps, mouseX, mouseY);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        if (this.field_230706_i_.field_71439_g != null && this.hideParticlesOld != this.hideParticles) {
            ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new DisableHearthParticlesMessage(HearthSaveDataHandler.serializeDisabledHearths()));
        }
    }

    @SubscribeEvent
    public static void preventScreenShift(GuiScreenEvent.PotionShiftEvent event) {
        AbstractHearthScreen screen;
        if (event.getGui() instanceof AbstractHearthScreen && (screen = (AbstractHearthScreen)event.getGui()).getBlockEntity().getEffects().isEmpty()) {
            event.setCanceled(true);
        }
    }
}

