/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import com.momosoftworks.coldsweat.common.fluid.ModFluidAttributes;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.FluidInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class SlushFluid
extends ForgeFlowingFluid {
    private static final ResourceLocation SLUSH_STILL = new ResourceLocation("cold_sweat", "block/slush_still");
    private static final ResourceLocation SLUSH_FLOW = new ResourceLocation("cold_sweat", "block/slush_flow");

    protected SlushFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static AbstractBlock.Properties getBlockProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200944_c().func_200943_b(100.0f);
    }

    public static ForgeFlowingFluid.Properties getForgeProperties() {
        return new ForgeFlowingFluid.Properties(FluidInit.SLUSH, FluidInit.FLOWING_SLUSH, ModFluidAttributes.builder(SLUSH_STILL, SLUSH_FLOW).color((state, level, pos, index) -> {
            if (level == null || pos == null) {
                return -1;
            }
            int color = BiomeColors.func_228363_c_((IBlockDisplayReader)level, (BlockPos)pos);
            int red = ColorHelper.PackedColor.func_233007_b_((int)color);
            int green = ColorHelper.PackedColor.func_233008_c_((int)color);
            int blue = ColorHelper.PackedColor.func_233009_d_((int)color);
            int alphaColor = ColorHelper.PackedColor.func_233006_a_((int)240, (int)red, (int)green, (int)blue);
            int white = ColorHelper.PackedColor.func_233006_a_((int)240, (int)255, (int)255, (int)255);
            return CSMath.blendColors(alphaColor, white, 0.65f);
        }).translationKey("block.cold_sweat.slush").sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L).temperature(280).viscosity(2000)).bucket(ItemInit.SLUSH_BUCKET).block(BlockInit.SLUSH);
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected int func_185698_b(IWorldReader worldIn) {
        return 2;
    }

    protected int func_204528_b(IWorldReader worldIn) {
        return 2;
    }

    public int func_205569_a(IWorldReader level) {
        return 30;
    }

    protected void func_205574_a(IWorld level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        FluidState targetFluidState = level.func_204610_c(pos);
        if (targetFluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
            BlockState resultBlock = Blocks.field_196604_cC.func_176223_P();
            if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
                level.func_180501_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)level, (BlockPos)pos, (BlockPos)pos, (BlockState)resultBlock), 3);
            }
            SlushFluid.fizz(level, pos);
            return;
        }
        super.func_205574_a(level, pos, blockState, direction, fluidState);
    }

    public static void fizz(IWorld ilevel, BlockPos pos) {
        if (ilevel instanceof World) {
            World level = (World)ilevel;
            Vector3d centerPos = CSMath.getCenterPos(pos);
            BlockParticleData particleData = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196604_cC.func_176223_P());
            WorldHelper.spawnParticleBatch(level, (IParticleData)particleData, centerPos.field_72450_a, centerPos.field_72448_b, centerPos.field_72449_c, 0.6, 0.6, 0.6, 15.0, 0.1);
            level.func_184133_a(null, pos, SoundEvents.field_187807_fF, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static class Source
    extends SlushFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int func_207192_d(FluidState state) {
            return 8;
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends SlushFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.func_207183_f((FluidState)((FluidState)this.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState state) {
            return (Integer)state.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

