/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncTempModifiersMessage {
    int entityId;
    CompoundNBT modifiers;

    public SyncTempModifiersMessage(LivingEntity entity, CompoundNBT modifiers) {
        this.entityId = entity.func_145782_y();
        this.modifiers = modifiers;
    }

    SyncTempModifiersMessage(int entityId, CompoundNBT modifiers) {
        this.entityId = entityId;
        this.modifiers = modifiers;
    }

    public static void encode(SyncTempModifiersMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
        buffer.func_150786_a(message.modifiers);
    }

    public static SyncTempModifiersMessage decode(PacketBuffer buffer) {
        return new SyncTempModifiersMessage(buffer.readInt(), buffer.func_150793_b());
    }

    public static void handle(SyncTempModifiersMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
                if (entity instanceof LivingEntity) {
                    EntityTempManager.getTemperatureCap((Entity)((LivingEntity)entity)).ifPresent(cap -> cap.deserializeModifiers(message.modifiers));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

