/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.Nullable;

public class RegistryModifierData<T extends ConfigData>
extends ConfigData {
    private final RegistryKey<Registry<T>> registry;
    private final List<ConfigData.Type> registryTypes;
    private final NegatableList<NbtRequirement> matches;
    private final List<ResourceLocation> entries;
    private final List<Operation> operations;
    private static final Codec<List<ConfigData.Type>> CONFIG_TYPE_CODEC = Codec.either(ConfigData.Type.CODEC, (Codec)ConfigData.Type.CODEC.listOf()).xmap(either -> (List)either.map(xva$0 -> Arrays.asList(xva$0), r -> r), Either::right);
    public static final Codec<RegistryModifierData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.xmap(s -> ModRegistries.getRegistryKey(s), key -> key.func_240901_a_()).fieldOf("registry").forGetter(data -> data.registry()), (App)CONFIG_TYPE_CODEC.optionalFieldOf("config_type", Arrays.asList(new ConfigData.Type[0])).forGetter(RegistryModifierData::configTypes), (App)NegatableList.listCodec(NbtRequirement.CODEC).optionalFieldOf("matches", new NegatableList()).forGetter(RegistryModifierData::matches), (App)ResourceLocation.field_240908_a_.listOf().optionalFieldOf("entries", Arrays.asList(new ResourceLocation[0])).forGetter(RegistryModifierData::entries), (App)Operation.CODEC.listOf().optionalFieldOf("operations", Arrays.asList(new Operation[0])).forGetter(data -> data.operations)).apply((Applicative)instance, RegistryModifierData::new));

    public RegistryModifierData(RegistryKey<Registry<T>> registry, List<ConfigData.Type> registryTypes, NegatableList<NbtRequirement> matches, List<ResourceLocation> entries, List<Operation> operations) {
        super(new NegatableList<String>());
        this.registry = registry;
        this.registryTypes = registryTypes;
        this.matches = matches;
        this.entries = entries;
        this.operations = operations;
    }

    public RegistryKey<Registry<T>> registry() {
        return this.registry;
    }

    public List<ConfigData.Type> configTypes() {
        return this.registryTypes;
    }

    public NegatableList<NbtRequirement> matches() {
        return this.matches;
    }

    public List<ResourceLocation> entries() {
        return this.entries;
    }

    public List<Operation> modifications() {
        return this.operations;
    }

    private boolean checkType(T object) {
        return this.registryTypes.isEmpty() || this.registryTypes.contains(((ConfigData)object).configType());
    }

    public boolean matches(T object) {
        if (!this.checkType(object)) {
            return false;
        }
        if (this.matches.isEmpty()) {
            return false;
        }
        Optional serializedOpt = ((ConfigData)object).getCodec().encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, object).result();
        return serializedOpt.map(serialized -> this.matches.test(nbt -> nbt.test((CompoundNBT)serialized))).orElse(false);
    }

    @Nullable
    public T applyModifications(T object) {
        T modifiedObject = object;
        for (Operation operation : this.operations) {
            T result = operation.modify(modifiedObject);
            if (result == null) {
                return null;
            }
            modifiedObject = result;
        }
        return modifiedObject;
    }

    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }

    public static class Operation {
        private final Type type;
        private final CompoundNBT data;
        public static final Codec<Operation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(Operation::type), (App)CompoundNBT.field_240597_a_.optionalFieldOf("data", (Object)new CompoundNBT()).forGetter(Operation::data)).apply((Applicative)instance, Operation::new));

        public Operation(Type type, CompoundNBT data) {
            this.type = type;
            this.data = data;
        }

        public Type type() {
            return this.type;
        }

        public CompoundNBT data() {
            return this.data;
        }

        @Nullable
        public <T extends ConfigData> T modify(T element) {
            Codec codec = element.getCodec();
            CompoundNBT elementTag = codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, element).result().orElse(new CompoundNBT());
            switch (this.type) {
                case DISABLE: {
                    return null;
                }
                case REPLACE: {
                    for (String key : this.data.func_150296_c()) {
                        if (!elementTag.func_74764_b(key)) continue;
                        elementTag.func_218657_a(key, this.data.func_74781_a(key));
                    }
                    break;
                }
                case MERGE: {
                    elementTag = Operation.mergeCompounds(elementTag, this.data);
                    break;
                }
                case APPEND: {
                    elementTag = Operation.appendCompound(elementTag, this.data);
                    break;
                }
                case REMOVE: {
                    elementTag = Operation.removeCompound(elementTag, this.data);
                }
            }
            CompoundNBT resultTag = elementTag;
            Optional result = codec.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)resultTag).result();
            return (T)result.orElseGet(() -> {
                ColdSweat.LOGGER.error("Failed to apply registry modification of type {} with data {} to data {}", (Object)this.type, (Object)this.data, (Object)resultTag);
                return element;
            });
        }

        private static CompoundNBT mergeCompounds(CompoundNBT original, CompoundNBT toMerge) {
            CompoundNBT merged = original.func_74737_b();
            for (String key : toMerge.func_150296_c()) {
                INBT originalValue = merged.func_74781_a(key);
                INBT toMergeValue = toMerge.func_74781_a(key);
                if (originalValue != null) {
                    if (originalValue instanceof CompoundNBT && toMergeValue instanceof CompoundNBT) {
                        merged.func_218657_a(key, (INBT)Operation.mergeCompounds((CompoundNBT)originalValue, (CompoundNBT)toMergeValue));
                        continue;
                    }
                    if (originalValue instanceof ListNBT && toMergeValue instanceof ListNBT) {
                        merged.func_218657_a(key, (INBT)Operation.mergeLists((ListNBT)originalValue, (ListNBT)toMergeValue));
                        continue;
                    }
                    if (!(originalValue instanceof NumberNBT) || !(toMergeValue instanceof StringNBT) || toMergeValue.func_150285_a_().length() <= 2) continue;
                    NumberNBT originalNumber = (NumberNBT)originalValue;
                    StringNBT operation = (StringNBT)toMergeValue;
                    double operand = Double.parseDouble(operation.func_150285_a_().substring(2));
                    double numberValue = originalNumber.func_150286_g();
                    switch (operation.func_150285_a_().substring(0, 2)) {
                        case "+=": {
                            numberValue += operand;
                            break;
                        }
                        case "-=": {
                            numberValue -= operand;
                            break;
                        }
                        case "*=": {
                            numberValue *= operand;
                            break;
                        }
                        case "/=": {
                            numberValue /= operand;
                            break;
                        }
                        case "^=": {
                            numberValue = Math.pow(numberValue, operand);
                            break;
                        }
                        case "%=": {
                            numberValue %= operand;
                            break;
                        }
                        default: {
                            merged.func_218657_a(key, toMergeValue);
                        }
                    }
                    if (originalNumber instanceof ByteNBT) {
                        merged.func_74774_a(key, (byte)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof ShortNBT) {
                        merged.func_74777_a(key, (short)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof IntNBT) {
                        merged.func_74768_a(key, (int)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof LongNBT) {
                        merged.func_74772_a(key, (long)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof FloatNBT) {
                        merged.func_74776_a(key, (float)numberValue);
                        continue;
                    }
                    if (!(originalNumber instanceof DoubleNBT)) continue;
                    merged.func_74780_a(key, numberValue);
                    continue;
                }
                merged.func_218657_a(key, toMergeValue);
            }
            return merged;
        }

        private static ListNBT mergeLists(ListNBT original, ListNBT toMerge) {
            final HashSet merged = new HashSet(original.func_74737_b());
            merged.addAll(toMerge);
            return new ListNBT(){
                {
                    this.addAll(merged);
                }
            };
        }

        private static CompoundNBT appendCompound(CompoundNBT original, CompoundNBT toAppend) {
            CompoundNBT appended = original.func_74737_b();
            for (String key : toAppend.func_150296_c()) {
                INBT originalValue = appended.func_74781_a(key);
                INBT toAppendValue = toAppend.func_74781_a(key);
                if (originalValue == null) {
                    appended.func_218657_a(key, toAppendValue);
                    continue;
                }
                if (!(originalValue instanceof CompoundNBT) || !(toAppendValue instanceof CompoundNBT)) continue;
                appended.func_218657_a(key, (INBT)Operation.appendCompound((CompoundNBT)originalValue, (CompoundNBT)toAppendValue));
            }
            return appended;
        }

        private static CompoundNBT removeCompound(CompoundNBT original, CompoundNBT toRemove) {
            CompoundNBT modified = original.func_74737_b();
            for (String key : toRemove.func_150296_c()) {
                INBT originalValue = modified.func_74781_a(key);
                INBT toRemoveValue = toRemove.func_74781_a(key);
                if (originalValue == null) continue;
                if (toRemoveValue instanceof CompoundNBT) {
                    if (!(originalValue instanceof CompoundNBT)) continue;
                    modified.func_218657_a(key, (INBT)Operation.removeCompound((CompoundNBT)originalValue, (CompoundNBT)toRemoveValue));
                    continue;
                }
                if (toRemoveValue instanceof StringNBT) {
                    modified.func_82580_o(key);
                    continue;
                }
                if (!(toRemoveValue instanceof ListNBT) || !(originalValue instanceof ListNBT)) continue;
                ListNBT newList = ((ListNBT)originalValue).func_74737_b();
                newList.removeAll((Collection)((ListNBT)toRemoveValue));
                modified.func_218657_a(key, (INBT)newList);
            }
            return modified;
        }
    }

    public static enum Type implements StringRepresentable
    {
        DISABLE("disable"),
        REPLACE("replace"),
        MERGE("merge"),
        APPEND("append"),
        REMOVE("remove");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Type byName(String name) {
            return (Type)EnumHelper.byName((Enum[])Type.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }
}

