/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Optional;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class FluidRequirement {
    private final NegatableList<Either<ITag<Fluid>, Fluid>> fluids;
    private final BlockRequirement.StateRequirement state;
    private final Optional<Boolean> isSource;
    public static final Codec<FluidRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrBuiltinCodec(Registry.field_239709_j_, Registry.field_212619_h)).optionalFieldOf("fluids", new NegatableList()).forGetter(FluidRequirement::fluids), (App)BlockRequirement.StateRequirement.CODEC.optionalFieldOf("state", (Object)BlockRequirement.StateRequirement.NONE).forGetter(FluidRequirement::state), (App)Codec.BOOL.optionalFieldOf("is_source").forGetter(FluidRequirement::isSource)).apply((Applicative)instance, FluidRequirement::new));
    public static final FluidRequirement NONE = new FluidRequirement(new NegatableList<Either<ITag<Fluid>, Fluid>>(), BlockRequirement.StateRequirement.NONE, Optional.empty());

    public FluidRequirement(NegatableList<Either<ITag<Fluid>, Fluid>> fluids, BlockRequirement.StateRequirement state, Optional<Boolean> isSource) {
        this.fluids = fluids;
        this.state = state;
        this.isSource = isSource;
    }

    public NegatableList<Either<ITag<Fluid>, Fluid>> fluids() {
        return this.fluids;
    }

    public BlockRequirement.StateRequirement state() {
        return this.state;
    }

    public Optional<Boolean> isSource() {
        return this.isSource;
    }

    public boolean test(World pLevel, BlockPos pPos) {
        if (!pLevel.func_195588_v(pPos)) {
            return true;
        }
        FluidState lState = pLevel.func_204610_c(pPos);
        return this.test(lState);
    }

    public boolean test(FluidState state) {
        if (!this.fluids.test((T either) -> (Boolean)either.map(tag -> state.func_206884_a(tag), fluid -> state.func_206886_c() == fluid))) {
            return false;
        }
        if (this.isSource.isPresent() && this.isSource.get().booleanValue() != state.func_206889_d()) {
            return false;
        }
        return this.state.test(state);
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FluidRequirement that = (FluidRequirement)obj;
        return this.fluids.equals(that.fluids) && this.state.equals(that.state);
    }
}

