/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.JsonHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootGenerator;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.mutable.MutableInt;

public class AddPiglinBartersModifier
extends LootModifier {
    private final List<com.momosoftworks.coldsweat.data.codec.LootEntry> additions;
    static ResourceLocation PIGLIN_BARTER_LOCATION = new ResourceLocation("gameplay/piglin_bartering");
    static Field POOLS = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
    static Field ENTRIES = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");

    protected AddPiglinBartersModifier(ILootCondition[] conditions, List<com.momosoftworks.coldsweat.data.codec.LootEntry> additions) {
        super(conditions);
        this.additions = additions;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, final LootContext context) {
        try {
            ArrayList<1> entries = new ArrayList<1>();
            MutableInt totalWeight = new MutableInt();
            for (LootPool pool : (List)POOLS.get(context.func_227502_a_(PIGLIN_BARTER_LOCATION))) {
                for (LootEntry container : (LootEntry[])ENTRIES.get(pool)) {
                    container.expand(context, entry -> {
                        entries.add(entry);
                        totalWeight.add(entry.func_186361_a(context.func_186491_f()));
                    });
                }
            }
            for (final com.momosoftworks.coldsweat.data.codec.LootEntry addition : this.additions) {
                entries.add(new ILootGenerator(){

                    public int func_186361_a(float luck) {
                        return CSMath.floor((float)addition.weight * (1.0f + context.func_186491_f()));
                    }

                    public void func_216188_a(Consumer<ItemStack> consumer, LootContext context1) {
                        consumer.accept(new ItemStack((IItemProvider)addition.item, context.func_216032_b().nextInt(addition.count.max + 1) + addition.count.min));
                    }
                });
                totalWeight.add(addition.weight);
            }
            AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
            int j = context.func_216032_b().nextInt(totalWeight.intValue());
            for (ILootGenerator iLootGenerator : entries) {
                if ((j -= iLootGenerator.func_186361_a(context.func_186491_f())) >= 0) continue;
                iLootGenerator.func_216188_a(stack::set, context);
                return ObjectArrayList.wrap((Object[])new ItemStack[]{stack.get()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generatedLoot;
    }

    static {
        POOLS.setAccessible(true);
        ENTRIES.setAccessible(true);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddPiglinBartersModifier> {
        public AddPiglinBartersModifier read(@Nonnull ResourceLocation location, JsonObject object, ILootCondition[] conditionsIn) {
            ArrayList<com.momosoftworks.coldsweat.data.codec.LootEntry> additions = new ArrayList<com.momosoftworks.coldsweat.data.codec.LootEntry>();
            for (JsonElement addition : JsonHelper.getAsJsonArray(object, "additions", new JsonArray())) {
                JsonObject additionObject = addition.getAsJsonObject();
                Optional<CompoundNBT> tag = additionObject.has("tag") ? Optional.of(CompoundNBT.field_240597_a_.parse((DynamicOps)JsonOps.INSTANCE, (Object)additionObject.get("tag")).getOrThrow(false, s -> {})) : Optional.empty();
                JsonObject count = JsonHelper.getAsJsonObject(additionObject, "count", new JsonObject());
                additions.add(new com.momosoftworks.coldsweat.data.codec.LootEntry((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JsonHelper.getAsString(additionObject, "item"))), tag, new IntegerBounds(JsonHelper.getAsInt(count, "min", 1), JsonHelper.getAsInt(count, "max", 1)), JsonHelper.getAsInt(additionObject, "weight", 1)));
            }
            return new AddPiglinBartersModifier(conditionsIn, additions);
        }

        public JsonObject write(AddPiglinBartersModifier instance) {
            JsonObject object = new JsonObject();
            JsonArray additions = new JsonArray();
            for (com.momosoftworks.coldsweat.data.codec.LootEntry addition : instance.additions) {
                JsonObject additionObject = new JsonObject();
                additionObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)addition.item).toString());
                JsonObject count = new JsonObject();
                count.addProperty("min", (Number)addition.count.min);
                count.addProperty("max", (Number)addition.count.max);
                additionObject.add("count", (JsonElement)count);
                additionObject.addProperty("weight", (Number)addition.weight);
                addition.tag.ifPresent(tag -> additionObject.add("nbt", (JsonElement)CompoundNBT.field_240597_a_.encodeStart((DynamicOps)JsonOps.INSTANCE, tag).result().orElseThrow(RuntimeException::new)));
                additions.add((JsonElement)additionObject);
            }
            object.add("additions", (JsonElement)additions);
            return object;
        }
    }
}

