/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class NBTHelper {
    private NBTHelper() {
    }

    public static CompoundNBT modifierToTag(TempModifier modifier) {
        CompoundNBT modifierTag = new CompoundNBT();
        ResourceLocation modifierId = TempModifierRegistry.getKey(modifier);
        if (modifierId == null) {
            ColdSweat.LOGGER.error("Failed to get key for TempModifier: {}", (Object)modifier.getClass().getSimpleName());
            return modifierTag;
        }
        modifierTag.func_74778_a("Id", modifierId.toString());
        modifierTag.func_218657_a("ModifierData", (INBT)modifier.getNBT());
        if (modifier.getExpireTime() != -1) {
            modifierTag.func_74768_a("ExpireTicks", modifier.getExpireTime());
        }
        if (modifier.getTickRate() > 1) {
            modifierTag.func_74768_a("TickRate", modifier.getTickRate());
        }
        modifierTag.func_74768_a("TicksExisted", modifier.getTicksExisted());
        modifierTag.func_74768_a("Hash", modifier.hashCode());
        return modifierTag;
    }

    public static Optional<TempModifier> tagToModifier(CompoundNBT modifierTag) {
        Optional<TempModifier> optional = TempModifierRegistry.getValue(new ResourceLocation(modifierTag.func_74779_i("Id")));
        optional.ifPresent(modifier -> {
            modifier.setNBT(modifierTag.func_74775_l("ModifierData"));
            if (modifierTag.func_74764_b("ExpireTicks")) {
                modifier.expires(modifierTag.func_74762_e("ExpireTicks"));
            }
            if (modifierTag.func_74764_b("TickRate")) {
                modifier.tickRate(modifierTag.func_74762_e("TickRate"));
            }
            modifier.setTicksExisted(modifierTag.func_74762_e("TicksExisted"));
        });
        return optional;
    }

    public static void incrementTag(CompoundNBT tag, String key, int amount, Predicate<Integer> predicate) {
        int value = tag.func_74762_e(key);
        if (predicate.test(value)) {
            tag.func_74768_a(key, value + amount);
        }
    }

    public static void incrementTag(Object owner, String key, int amount) {
        NBTHelper.incrementTag(owner, key, amount, (Integer tag) -> true);
    }

    public static int incrementTag(Object owner, String key, int amount, Predicate<Integer> predicate) {
        CompoundNBT tag;
        if (owner instanceof Entity) {
            tag = ((Entity)owner).getPersistentData();
        } else if (owner instanceof ItemStack) {
            tag = ((ItemStack)owner).func_196082_o();
        } else if (owner instanceof TileEntity) {
            tag = ((TileEntity)owner).getTileData();
        } else if (owner instanceof TempModifier) {
            tag = ((TempModifier)owner).getNBT();
        } else {
            return 0;
        }
        NBTHelper.incrementTag(tag, key, amount, predicate);
        return tag.func_74762_e(key);
    }

    public static CompoundNBT getTagOrEmpty(ItemStack stack) {
        return CSMath.orElse(stack.func_77978_p(), new CompoundNBT());
    }

    public static <T extends INBT> T getOrPutTag(LivingEntity entity, String tag, T dfault) {
        CompoundNBT data = entity.getPersistentData();
        if (!data.func_74764_b(tag) || data.func_74781_a(tag).func_74732_a() != dfault.func_74732_a()) {
            data.func_218657_a(tag, dfault);
        }
        return (T)data.func_74781_a(tag);
    }

    public static <T extends INBT> T getOrPutTag(ItemStack stack, String tag, T dfault) {
        CompoundNBT data = stack.func_196082_o();
        if (!data.func_74764_b(tag) || data.func_74781_a(tag).func_74732_a() != dfault.func_74732_a()) {
            data.func_218657_a(tag, dfault);
        }
        return (T)data.func_74781_a(tag);
    }

    public static String getTraitTagKey(Temperature.Trait trait) {
        return trait.func_176610_l();
    }

    @SubscribeEvent
    public static void convertTagsInContainer(PlayerContainerEvent.Open event) {
        NBTHelper.updateItemTags(event.getContainer().field_75151_b.stream().map(Slot::func_75211_c).collect(Collectors.toList()));
    }

    private static void updateItemTags(Collection<ItemStack> items) {
        for (ItemStack stack : items) {
            Item item = stack.func_77973_b();
            CompoundNBT tag = NBTHelper.getTagOrEmpty(stack);
            if (item == ModItems.SOULSPRING_LAMP) {
                if (!tag.func_74764_b("fuel")) continue;
                tag.func_74780_a("Fuel", tag.func_74769_h("fuel"));
                tag.func_82580_o("fuel");
                continue;
            }
            if (item != ModItems.FILLED_WATERSKIN || !tag.func_74764_b("temperature")) continue;
            tag.func_74780_a("Temperature", tag.func_74769_h("temperature"));
            tag.func_82580_o("temperature");
        }
    }

    public static CompoundNBT parseCompoundNbt(String tag) {
        if (NBTHelper.isBlank(tag)) {
            return new CompoundNBT();
        }
        try {
            return JsonToNBT.func_180713_a((String)tag);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Error parsing compound tag \"{}\": {}", (Object)tag, (Object)e.getMessage());
            e.printStackTrace();
            return new CompoundNBT();
        }
    }

    public static ListNBT listTagOf(List<?> list) {
        ListNBT tag = new ListNBT();
        for (Object obj : list) {
            if (obj instanceof INBT) {
                tag.add((Object)((INBT)obj));
                continue;
            }
            tag.add((Object)NBTHelper.serialize(obj));
        }
        return tag;
    }

    @Nullable
    public static Object deserialize(INBT tag) {
        if (tag instanceof IntNBT) {
            return ((IntNBT)tag).func_150287_d();
        }
        if (tag instanceof FloatNBT) {
            return Float.valueOf(((FloatNBT)tag).func_150288_h());
        }
        if (tag instanceof DoubleNBT) {
            return ((DoubleNBT)tag).func_150286_g();
        }
        if (tag instanceof LongNBT) {
            return ((LongNBT)tag).func_150291_c();
        }
        if (tag instanceof ShortNBT) {
            return ((ShortNBT)tag).func_150289_e();
        }
        if (tag instanceof ByteNBT) {
            return ((ByteNBT)tag).func_150290_f();
        }
        if (tag instanceof ByteArrayNBT) {
            return ((ByteArrayNBT)tag).func_150285_a_();
        }
        if (tag instanceof IntArrayNBT) {
            return ((IntArrayNBT)tag).func_150302_c();
        }
        if (tag instanceof LongArrayNBT) {
            return ((LongArrayNBT)tag).func_197652_h();
        }
        if (tag instanceof StringNBT) {
            return ((StringNBT)tag).func_150285_a_();
        }
        if (tag instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)tag;
            if (compound.func_74764_b("value") && compound.func_74764_b("class")) {
                return NBTHelper.tryReadEnum(compound);
            }
        } else if (tag instanceof ListNBT) {
            return ((ListNBT)tag).stream().map(NBTHelper::deserialize).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    private static <T extends Enum<T>> Enum<T> tryReadEnum(CompoundNBT tag) {
        try {
            Class<?> clazz = Class.forName(tag.func_74779_i("class"));
            return Enum.valueOf(clazz, tag.func_74779_i("value"));
        }
        catch (ClassNotFoundException e) {
            ColdSweat.LOGGER.error("Failed to read enum from compound tag: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static INBT serialize(Object obj) {
        if (obj instanceof Integer) {
            return IntNBT.func_229692_a_((int)((Integer)obj));
        }
        if (obj instanceof Float) {
            return FloatNBT.func_229689_a_((float)((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return DoubleNBT.func_229684_a_((double)((Double)obj));
        }
        if (obj instanceof Long) {
            return LongNBT.func_229698_a_((long)((Long)obj));
        }
        if (obj instanceof Short) {
            return ShortNBT.func_229701_a_((short)((Short)obj));
        }
        if (obj instanceof Byte) {
            return ByteNBT.func_229671_a_((byte)((Byte)obj));
        }
        if (obj instanceof String) {
            return StringNBT.func_229705_a_((String)((String)obj));
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ListNBT tag = new ListNBT();
            for (Object item : list) {
                INBT itemTag = NBTHelper.serialize(item);
                if (itemTag == null) continue;
                tag.add((Object)itemTag);
            }
            return tag;
        }
        if (obj instanceof Enum) {
            final Enum enm = (Enum)obj;
            return new CompoundNBT(){
                {
                    this.func_74778_a("value", enm.name());
                    this.func_74778_a("class", enm.getClass().getName());
                }
            };
        }
        return null;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }
}

