/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat;

import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.common.command.argument.NicerEnumArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempAttributeTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TemperatureTraitArgument;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.AttributeInit;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.EffectInit;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.core.init.FeatureInit;
import com.momosoftworks.coldsweat.core.init.FluidInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.init.MenuInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.init.PotionInit;
import com.momosoftworks.coldsweat.core.init.SoundInit;
import com.momosoftworks.coldsweat.core.init.TempEffectInit;
import com.momosoftworks.coldsweat.core.itemgroup.InsulationItemsGroup;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.util.registries.ModFluids;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="cold_sweat")
@Mod.EventBusSubscriber
public class ColdSweat {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cold Sweat");
    public static final String MOD_ID = "cold_sweat";
    public static final IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();

    public ColdSweat() {
        MOD_BUS.addListener(this::commonSetup);
        MOD_BUS.addListener(this::clientSetup);
        MOD_BUS.addListener(this::registerCaps);
        MOD_BUS.addListener(this::updateConfigs);
        if (CompatManager.isCuriosLoaded()) {
            MOD_BUS.addListener(this::registerCurioSlots);
        }
        BlockInit.BLOCKS.register(MOD_BUS);
        FluidInit.FLUIDS.register(MOD_BUS);
        ItemInit.ITEMS.register(MOD_BUS);
        EntityInit.ENTITY_TYPES.register(MOD_BUS);
        BlockEntityInit.BLOCK_ENTITY_TYPES.register(MOD_BUS);
        MenuInit.MENU_TYPES.register(MOD_BUS);
        EffectInit.EFFECTS.register(MOD_BUS);
        ParticleTypesInit.PARTICLES.register(MOD_BUS);
        PotionInit.POTIONS.register(MOD_BUS);
        SoundInit.SOUNDS.register(MOD_BUS);
        FeatureInit.FEATURES.register(MOD_BUS);
        AttributeInit.ATTRIBUTES.register(MOD_BUS);
        TempEffectInit.TEMP_EFFECTS.register(MOD_BUS);
        ModUpdater.updateFileNames();
        MainSettingsConfig.setup();
        ClientSettingsConfig.setup();
        WorldSettingsConfig.setup();
        ItemSettingsConfig.setup();
        EntitySettingsConfig.setup();
        CompatManager.registerEventHandlers();
        MOD_BUS.addListener(event -> {
            for (RegistryHolder<?> holder : ModRegistries.getRegistries().values()) {
                event.create(new RegistryBuilder().setType(holder.type()).setName(holder.key().m_135782_()).dataPackRegistry(holder.codec(), holder.codec()));
            }
        });
    }

    public static ResourceLocation createKey(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static String getVersion() {
        return FMLLoader.getLoadingModList().getModFileById(MOD_ID).versionString();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ColdSweatPacketHandler.init();
        event.enqueueWork(() -> {
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.TEMPERATURE_CHANGED);
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.SOUL_LAMP_FUELLED);
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.BLOCK_AFFECTS_TEMP);
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.ARMOR_INSULATED);
            InsulationItemsGroup.INSULATION_ITEMS.register();
            ArgumentTypes.m_121601_((String)"temperature_trait", TemperatureTraitArgument.class, (ArgumentSerializer)new TemperatureTraitArgument.Serializer());
            ArgumentTypes.m_121601_((String)"temp_attribute_trait", TempAttributeTraitArgument.class, (ArgumentSerializer)new TempAttributeTraitArgument.Serializer());
            ArgumentTypes.m_121601_((String)"temp_modifier_trait", TempModifierTraitArgument.class, (ArgumentSerializer)new TempModifierTraitArgument.Serializer());
            ArgumentTypes.m_121601_((String)"temp_modifier", TempModifierArgument.class, (ArgumentSerializer)new TempModifierArgument.Serializer());
            ArgumentTypes.m_121601_((String)"enum", NicerEnumArgument.class, new NicerEnumArgument.Serializer());
        });
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.HEARTH_BOTTOM.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.SOUL_STALK.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.SLUSH, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.FLOWING_SLUSH, (RenderType)RenderType.m_110466_());
        });
    }

    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(PlayerTempCap.class);
        event.register(EntityTempCap.class);
        event.register(ItemInsulationCap.class);
        event.register(ShearableFurCap.class);
    }

    public void updateConfigs(FMLLoadCompleteEvent event) {
        ModUpdater.updateConfigs();
    }

    public void registerCurioSlots(InterModEnqueueEvent event) {
        event.enqueueWork(() -> InterModComms.sendTo((String)MOD_ID, (String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build()));
    }
}

