/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.Heightmap;

public class ElevationTempModifier
extends TempModifier {
    public ElevationTempModifier() {
        this(49);
    }

    public ElevationTempModifier(int samples) {
        this.getNBT().m_128405_("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        Level level = entity.f_19853_;
        DimensionTempData dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get(entity.f_19853_.m_5962_()).get(level.m_204156_());
        if (dimTempOverride != null) {
            return temp -> temp;
        }
        if (level.m_6042_().m_63946_()) {
            return temp -> temp;
        }
        ArrayList<Pair> depthTable = new ArrayList<Pair>();
        for (BlockPos pos : WorldHelper.getPositionGrid(entity.m_142538_(), this.getNBT().m_128451_("Samples"), 10)) {
            depthTable.add(Pair.of((Object)pos, (Object)CSMath.getDistance((Vec3i)entity.m_142538_(), (Vec3i)pos)));
        }
        BlockPos translatedPos = CompatManager.isValkyrienSkiesLoaded() ? CompatManager.Valkyrien.transformIfShipPos(level, entity.m_142538_()) : entity.m_142538_();
        int normalSkylight = entity.f_19853_.m_45517_(LightLayer.SKY, entity.m_142538_());
        int translatedSkylight = entity.f_19853_.m_45517_(LightLayer.SKY, translatedPos);
        int skylight = Math.min(normalSkylight, translatedSkylight);
        ArrayList<Pair> depthRegions = new ArrayList<Pair>(depthTable.size());
        block1: for (Pair pair : depthTable) {
            int groundLevel;
            int minY;
            BlockPos originalPos = (BlockPos)pair.getFirst();
            int originalY = originalPos.m_123342_();
            int adjustedY = CSMath.betweenInclusive(originalY, minY = level.m_141937_(), groundLevel = WorldHelper.getHeight(originalPos, level, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)) ? CSMath.clamp(originalY + skylight - 4, minY, groundLevel) : (originalY >= groundLevel ? CSMath.clamp(originalY + skylight - 4, groundLevel, originalY) : CSMath.clamp(originalY + skylight - 4, originalY, minY));
            BlockPos pos = new BlockPos(originalPos.m_123341_(), adjustedY, originalPos.m_123343_());
            double distance = (Double)pair.getSecond();
            for (DepthTempData data : ConfigSettings.DEPTH_REGIONS.get().get((Object)level.m_6042_())) {
                DepthTempData.TempRegion region = data.getRegion(level, pos);
                if (region == null) continue;
                int regionMax = region.top().getHeight(pos, level);
                int regionMin = region.bottom().getHeight(pos, level);
                depthRegions.add(Pair.of((Object)pos, (Object)new RegionEntry(region, distance, regionMin, regionMax)));
                continue block1;
            }
            depthRegions.add(Pair.of((Object)pos, (Object)new RegionEntry(null, distance, 0, 0)));
        }
        return temp -> {
            ArrayList<Pair> depthTemps = new ArrayList<Pair>();
            for (Pair entry : depthRegions) {
                BlockPos pos = (BlockPos)entry.getFirst();
                RegionEntry regionEntry = (RegionEntry)entry.getSecond();
                DepthTempData.TempRegion region = regionEntry.region();
                if (region == null) continue;
                double distance = regionEntry.distance();
                int maxY = regionEntry.maxY();
                int minY = regionEntry.minY();
                double depthTemp = region.getTemperature((double)temp, pos, level, maxY, minY);
                double weight = 1.0 / (distance / 10.0 + 1.0);
                depthTemps.add(new Pair((Object)depthTemp, (Object)weight));
            }
            if (depthTemps.isEmpty()) {
                return temp;
            }
            return CSMath.weightedAverage(depthTemps);
        };
    }

    private record RegionEntry(DepthTempData.TempRegion region, double distance, int minY, int maxY) {
    }
}

