/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class HearthScreen
extends AbstractHearthScreen<HearthContainer> {
    private static final ResourceLocation HEARTH_GUI = new ResourceLocation("cold_sweat", "textures/gui/screen/hearth_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((HearthContainer)this.f_97732_).te;
    }

    public HearthScreen(HearthContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)new TranslatableComponent("container.cold_sweat.hearth"));
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HEARTH_GUI);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int maxGaugeHeight = 14;
        int hotGaugeHeight = ((HearthContainer)this.f_97732_).getHotFuel() <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, ((HearthContainer)this.f_97732_).getHotFuel(), 0.0f, ((HearthContainer)this.f_97732_).te.getMaxFuel()));
        int coldGaugeHeight = ((HearthContainer)this.f_97732_).getColdFuel() <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, ((HearthContainer)this.f_97732_).getColdFuel(), 0.0f, ((HearthContainer)this.f_97732_).te.getMaxFuel()));
        HearthScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 62), (int)(this.f_97736_ + 49 + (maxGaugeHeight - hotGaugeHeight)), (float)176.0f, (float)(maxGaugeHeight - hotGaugeHeight), (int)14, (int)hotGaugeHeight, (int)256, (int)256);
        HearthScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 100), (int)(this.f_97736_ + 49 + (maxGaugeHeight - coldGaugeHeight)), (float)190.0f, (float)(maxGaugeHeight - coldGaugeHeight), (int)14, (int)coldGaugeHeight, (int)256, (int)256);
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            boolean coolingOn = ((HearthContainer)this.f_97732_).te.isCoolingOn();
            boolean heatingOn = ((HearthContainer)this.f_97732_).te.isHeatingOn();
            HearthScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 63), (int)(this.f_97736_ + 64), (float)176.0f, (float)(heatingOn ? 28.0f : 32.0f), (int)13, (int)4, (int)256, (int)256);
            HearthScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 101), (int)(this.f_97736_ + 64), (float)176.0f, (float)(coolingOn ? 28.0f : 32.0f), (int)13, (int)4, (int)256, (int)256);
            if (CSMath.betweenInclusive(mouseX, this.f_97735_ + 60, this.f_97735_ + 76) && CSMath.betweenInclusive(mouseY, this.f_97736_ + 61, this.f_97736_ + 67)) {
                this.m_96597_(poseStack, List.of(new TranslatableComponent(heatingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")), mouseX, mouseY);
            }
            if (CSMath.betweenInclusive(mouseX, this.f_97735_ + 98, this.f_97735_ + 114) && CSMath.betweenInclusive(mouseY, this.f_97736_ + 61, this.f_97736_ + 67)) {
                this.m_96597_(poseStack, List.of(new TranslatableComponent(coolingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")), mouseX, mouseY);
            }
        }
    }
}

