/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.create;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.blockentity.ThermolithBlockEntity;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ColdSweatDisplayBehaviors {
    public static DisplayBehaviour THERMOLITH;

    public static class Thermolith
    extends SingleLineDisplaySource {
        protected MutableComponent provideLine(DisplayLinkContext displayLinkContext, DisplayTargetStats displayTargetStats) {
            BlockEntity blockEntity = displayLinkContext.getSourceBlockEntity();
            if (blockEntity instanceof ThermolithBlockEntity) {
                ThermolithBlockEntity thermolith = (ThermolithBlockEntity)blockEntity;
                double temperature = WorldHelper.getTemperatureAt(thermolith.m_58904_(), thermolith.m_58899_());
                Temperature.Units units = Temperature.Units.values()[displayLinkContext.sourceConfig().m_128451_("Units")];
                double convertedTemp = Temperature.convert(temperature, Temperature.Units.MC, units, true);
                String places = units == Temperature.Units.MC ? "%.2f" : "%.0f";
                String text = String.format(places + "%s", convertedTemp, units.getFormattedName());
                return new TextComponent(text);
            }
            return new TextComponent("");
        }

        protected boolean allowsLabeling(DisplayLinkContext displayLinkContext) {
            return true;
        }

        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addSelectionScrollInput(0, 137, (input, label) -> input.forOptions(List.of(Components.literal((String)Temperature.Units.F.getFormattedName()), Components.literal((String)Temperature.Units.C.getFormattedName()), Components.literal((String)Temperature.Units.MC.getFormattedName()))).titled((MutableComponent)new TranslatableComponent("cold_sweat.config.units.name")), "Units");
            }
        }

        public Component getName() {
            return new TranslatableComponent("block.cold_sweat.thermolith");
        }
    }
}

