/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class NBTHelper {
    private NBTHelper() {
    }

    public static CompoundTag modifierToTag(TempModifier modifier) {
        CompoundTag modifierTag = new CompoundTag();
        ResourceLocation modifierId = TempModifierRegistry.getKey(modifier);
        if (modifierId == null) {
            ColdSweat.LOGGER.error("Failed to get key for TempModifier: {}", (Object)modifier.getClass().getSimpleName());
            return modifierTag;
        }
        modifierTag.m_128359_("Id", modifierId.toString());
        modifierTag.m_128365_("ModifierData", (Tag)modifier.getNBT());
        if (modifier.getExpireTime() != -1) {
            modifierTag.m_128405_("ExpireTicks", modifier.getExpireTime());
        }
        if (modifier.getTickRate() > 1) {
            modifierTag.m_128405_("TickRate", modifier.getTickRate());
        }
        modifierTag.m_128405_("TicksExisted", modifier.getTicksExisted());
        modifierTag.m_128405_("Hash", modifier.hashCode());
        return modifierTag;
    }

    public static Optional<TempModifier> tagToModifier(CompoundTag modifierTag) {
        Optional<TempModifier> optional = TempModifierRegistry.getValue(new ResourceLocation(modifierTag.m_128461_("Id")));
        optional.ifPresent(modifier -> {
            modifier.setNBT(modifierTag.m_128469_("ModifierData"));
            if (modifierTag.m_128441_("ExpireTicks")) {
                modifier.expires(modifierTag.m_128451_("ExpireTicks"));
            }
            if (modifierTag.m_128441_("TickRate")) {
                modifier.tickRate(modifierTag.m_128451_("TickRate"));
            }
            modifier.setTicksExisted(modifierTag.m_128451_("TicksExisted"));
        });
        return optional;
    }

    public static void incrementTag(CompoundTag tag, String key, int amount, Predicate<Integer> predicate) {
        int value = tag.m_128451_(key);
        if (predicate.test(value)) {
            tag.m_128405_(key, value + amount);
        }
    }

    public static void incrementTag(Object owner, String key, int amount) {
        NBTHelper.incrementTag(owner, key, amount, (Integer tag) -> true);
    }

    public static int incrementTag(Object owner, String key, int amount, Predicate<Integer> predicate) {
        CompoundTag tag;
        if (owner instanceof Entity) {
            Entity entity = (Entity)owner;
            tag = entity.getPersistentData();
        } else if (owner instanceof ItemStack) {
            ItemStack stack = (ItemStack)owner;
            tag = stack.m_41784_();
        } else if (owner instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)owner;
            tag = blockEntity.getTileData();
        } else if (owner instanceof TempModifier) {
            TempModifier modifier = (TempModifier)owner;
            tag = modifier.getNBT();
        } else {
            return 0;
        }
        NBTHelper.incrementTag(tag, key, amount, predicate);
        return tag.m_128451_(key);
    }

    public static CompoundTag getTagOrEmpty(ItemStack stack) {
        return CSMath.orElse(stack.m_41783_(), new CompoundTag());
    }

    public static <T extends Tag> T getOrPutTag(LivingEntity entity, String tag, T dfault) {
        CompoundTag data = entity.getPersistentData();
        if (!data.m_128441_(tag) || data.m_128423_(tag).m_7060_() != dfault.m_7060_()) {
            data.m_128365_(tag, dfault);
        }
        return (T)data.m_128423_(tag);
    }

    public static <T extends Tag> T getOrPutTag(ItemStack stack, String tag, T dfault) {
        CompoundTag data = stack.m_41784_();
        if (!data.m_128441_(tag) || data.m_128423_(tag).m_7060_() != dfault.m_7060_()) {
            data.m_128365_(tag, dfault);
        }
        return (T)data.m_128423_(tag);
    }

    public static String getTraitTagKey(Temperature.Trait trait) {
        return trait.m_7912_();
    }

    @SubscribeEvent
    public static void convertTagsInContainer(PlayerContainerEvent.Open event) {
        NBTHelper.updateItemTags(event.getContainer().f_38839_.stream().map(Slot::m_7993_).toList());
    }

    private static void updateItemTags(Collection<ItemStack> items) {
        for (ItemStack stack : items) {
            Item item = stack.m_41720_();
            CompoundTag tag = NBTHelper.getTagOrEmpty(stack);
            if (item == ModItems.SOULSPRING_LAMP) {
                if (!tag.m_128441_("fuel")) continue;
                tag.m_128347_("Fuel", tag.m_128459_("fuel"));
                tag.m_128473_("fuel");
                continue;
            }
            if (item != ModItems.FILLED_WATERSKIN || !tag.m_128441_("temperature")) continue;
            tag.m_128347_("Temperature", tag.m_128459_("temperature"));
            tag.m_128473_("temperature");
        }
    }

    public static CompoundTag parseCompoundNbt(String tag) {
        if (tag.isBlank()) {
            return new CompoundTag();
        }
        try {
            return TagParser.m_129359_((String)tag);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Error parsing compound tag \"{}\": {}", (Object)tag, (Object)e.getMessage());
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    public static ListTag listTagOf(List<?> list) {
        ListTag tag = new ListTag();
        for (Object obj : list) {
            if (obj instanceof Tag) {
                Tag tg = (Tag)obj;
                tag.add((Object)tg);
                continue;
            }
            tag.add((Object)NBTHelper.serialize(obj));
        }
        return tag;
    }

    @Nullable
    public static Object deserialize(Tag tag) {
        if (tag instanceof IntTag) {
            IntTag integer = (IntTag)tag;
            return integer.m_7047_();
        }
        if (tag instanceof FloatTag) {
            FloatTag floating = (FloatTag)tag;
            return Float.valueOf(floating.m_7057_());
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return doubleTag.m_7061_();
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return longTag.m_7046_();
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return shortTag.m_7053_();
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.m_7063_();
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArray = (ByteArrayTag)tag;
            return byteArray.m_7916_();
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArray = (IntArrayTag)tag;
            return intArray.m_128648_();
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArray = (LongArrayTag)tag;
            return longArray.m_128851_();
        }
        if (tag instanceof StringTag) {
            StringTag string = (StringTag)tag;
            return string.m_7916_();
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            if (compound.m_128441_("value") && compound.m_128441_("class")) {
                return NBTHelper.tryReadEnum(compound);
            }
        } else if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            return list.stream().map(NBTHelper::deserialize).toList();
        }
        return null;
    }

    @Nullable
    private static <T extends Enum<T>> Enum<T> tryReadEnum(CompoundTag tag) {
        try {
            Class<?> clazz = Class.forName(tag.m_128461_("class"));
            return Enum.valueOf(clazz, tag.m_128461_("value"));
        }
        catch (ClassNotFoundException e) {
            ColdSweat.LOGGER.error("Failed to read enum from compound tag: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static Tag serialize(Object obj) {
        if (obj instanceof Integer) {
            Integer integer = (Integer)obj;
            return IntTag.m_128679_((int)integer);
        }
        if (obj instanceof Float) {
            Float floating = (Float)obj;
            return FloatTag.m_128566_((float)floating.floatValue());
        }
        if (obj instanceof Double) {
            Double doubleTag = (Double)obj;
            return DoubleTag.m_128500_((double)doubleTag);
        }
        if (obj instanceof Long) {
            Long longTag = (Long)obj;
            return LongTag.m_128882_((long)longTag);
        }
        if (obj instanceof Short) {
            Short shortTag = (Short)obj;
            return ShortTag.m_129258_((short)shortTag);
        }
        if (obj instanceof Byte) {
            Byte byteTag = (Byte)obj;
            return ByteTag.m_128266_((byte)byteTag);
        }
        if (obj instanceof String) {
            String string = (String)obj;
            return StringTag.m_129297_((String)string);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ListTag tag = new ListTag();
            for (Object item : list) {
                Tag itemTag = NBTHelper.serialize(item);
                if (itemTag == null) continue;
                tag.add((Object)itemTag);
            }
            return tag;
        }
        if (obj instanceof Enum) {
            final Enum enm = (Enum)obj;
            return new CompoundTag(){
                {
                    this.m_128359_("value", enm.name());
                    this.m_128359_("class", enm.getClass().getName());
                }
            };
        }
        return null;
    }
}

