/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;

public class OptionalHolder<T> {
    private final ResourceKey<T> key;
    private Holder<T> value = null;

    public OptionalHolder(ResourceKey<T> key) {
        this.key = key;
        ConfigLoadingHandler.addOptionalHolder(this);
    }

    public ResourceKey<T> key() {
        return this.key;
    }

    public Holder<T> get() {
        return Optional.ofNullable(this.value).orElseThrow(() -> new RuntimeException("Optional holder value is not set for key: " + this.key));
    }

    public Optional<Holder<T>> value() {
        return Optional.ofNullable(this.value);
    }

    public void setValue(Holder<T> value) {
        this.value = value;
    }

    public static <T> OptionalHolder<T> ofHolder(Holder<T> holder) {
        OptionalHolder<T> opt = new OptionalHolder<T>((ResourceKey)holder.m_203543_().orElseThrow());
        opt.setValue(holder);
        return opt;
    }

    public boolean is(Holder<T> holder) {
        return Objects.equals(this.value, holder);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalHolder)) {
            return false;
        }
        OptionalHolder that = (OptionalHolder)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return "OptionalHolder{key=" + this.key + ", value=" + (this.value != null ? this.value.m_203334_() : null) + "}";
    }
}

