/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.block_temp;

import com.google.common.collect.ImmutableSet;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockTemp {
    private final Set<Block> validBlocks;
    private final double maxEffect;
    private final double minEffect;
    private final double maxTemperature;
    private final double minTemperature;
    private final double range;
    private final boolean fade;
    private final boolean logarithmic;

    public abstract double getTemperature(Level var1, @Nullable LivingEntity var2, BlockState var3, BlockPos var4, double var5);

    public boolean isValid(Level level, BlockPos pos, BlockState state) {
        return true;
    }

    public BlockTemp(double minEffect, double maxEffect, double minTemp, double maxTemp, double range, boolean fade, boolean logarithmic, Block ... blocks) {
        this.validBlocks = ImmutableSet.builder().add((Object[])blocks).build();
        this.minEffect = minEffect;
        this.maxEffect = maxEffect;
        this.minTemperature = minTemp;
        this.maxTemperature = maxTemp;
        this.range = range;
        this.fade = fade;
        this.logarithmic = logarithmic;
    }

    public BlockTemp(double minEffect, double maxEffect, double minTemp, double maxTemp, double range, boolean fade, Block ... blocks) {
        this(minEffect, maxEffect, minTemp, maxTemp, range, fade, false, blocks);
    }

    public BlockTemp(Block ... blocks) {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, true, false, blocks);
    }

    public boolean hasBlock(Block block) {
        return this.validBlocks.contains(block);
    }

    public Set<Block> getAffectedBlocks() {
        return this.validBlocks;
    }

    public double maxEffect() {
        return this.maxEffect;
    }

    public double minEffect() {
        return this.minEffect;
    }

    public double maxTemperature() {
        return this.maxTemperature;
    }

    public double minTemperature() {
        return this.minTemperature;
    }

    public boolean logarithmic() {
        return this.logarithmic;
    }

    public double range() {
        return Math.min(this.range, (double)ConfigSettings.BLOCK_RANGE.get().intValue());
    }

    public boolean fade() {
        return this.fade;
    }
}

