/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.tag.ModBiomeTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WaterTempModifier
extends TempModifier {
    private static final double WATER_SOAK_SPEED = 0.1;
    private static final double RAIN_SOAK_SPEED = 0.0125;
    private static final double DRY_SPEED = 0.0015;

    public WaterTempModifier() {
        this(-0.01);
    }

    public WaterTempModifier(double temperature) {
        this.getNBT().m_128347_("Temperature", temperature);
    }

    public double getTemperature() {
        return this.getNBT().m_128459_("Temperature");
    }

    public double getMaxTemperature(LivingEntity entity) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double maxTemp = ConfigSettings.MAX_TEMP.get();
        double minTemp = ConfigSettings.MIN_TEMP.get();
        return CSMath.clamp(Math.abs(CSMath.average(maxTemp, minTemp) - worldTemp) / 2.0, 0.23, 0.5);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        boolean isWarm = entity.m_9236_().m_204166_(entity.m_20183_()).m_203656_(ModBiomeTags.HAS_HOT_WATER);
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double minWorldTemp = ConfigSettings.MIN_TEMP.get();
        double maxWorldTemp = ConfigSettings.MAX_TEMP.get();
        double configDrySpeed = ConfigSettings.DRYOFF_SPEED.get() * 0.0015;
        double temperature = this.getTemperature();
        double addAmount = WorldHelper.isInWater((Entity)entity) ? 0.1 * (double)(isWarm ? 1 : -1) : (WorldHelper.isRainingAt(entity.m_9236_(), entity.m_20183_()) ? 0.0125 : 0.0);
        double dryAmount = CSMath.blendExp(configDrySpeed, configDrySpeed * 10.0, worldTemp, minWorldTemp, maxWorldTemp, 100.0);
        double maxTemp = this.getMaxTemperature(entity);
        double newTemperature = CSMath.clamp(CSMath.shrink(temperature + addAmount, dryAmount), -maxTemp, maxTemp);
        if (newTemperature == 0.0) {
            this.expires(0);
        }
        this.getNBT().m_128347_("Temperature", newTemperature);
        if (temperature != newTemperature) {
            this.markDirty();
        }
        return temp -> temp + newTemperature;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (entity.m_9236_().m_5776_() && ConfigSettings.WATER_EFFECT_SETTING.get().showParticles() && !entity.m_20069_() && Math.random() < Math.abs(this.getNBT().m_128459_("Temperature")) * 2.0) {
            double randX = (double)entity.m_20205_() * (Math.random() - 0.5);
            double randY = (double)entity.m_20206_() * Math.random();
            double randZ = (double)entity.m_20205_() * (Math.random() - 0.5);
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_() + randX, entity.m_20186_() + randY, entity.m_20189_() + randZ, 0.0, 0.0, 0.0);
        }
    }
}

