/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSoulspringTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation TOOLTIP = new ResourceLocation("cold_sweat:textures/gui/tooltip/soulspring_lamp_fuel.png");
    private static final ResourceLocation TOOLTIP_HC = new ResourceLocation("cold_sweat:textures/gui/tooltip/soulspring_lamp_fuel_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    double fuel;

    public ClientSoulspringTooltip(double fuel) {
        this.fuel = fuel;
    }

    public int m_142103_() {
        return TooltipHandler.isShiftDown() ? CSMath.ceil((double)ConfigSettings.SOULSPRING_LAMP_FUEL.get().size() / 6.0) * 16 + 14 : 12;
    }

    public int m_142069_(Font font) {
        return TooltipHandler.isShiftDown() ? Math.min(6, ConfigSettings.SOULSPRING_LAMP_FUEL.get().size()) * 16 : 32;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("cold_sweat:textures/gui/tooltip/soulspring_lamp_fuel.png"));
        graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, 0.0f, 0.0f, 30, 8, 30, 34);
        graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, 0.0f, 16.0f, (int)(this.fuel / 2.1333), 8, 30, 34);
        if (TooltipHandler.isShiftDown()) {
            graphics.m_280398_(TOOLTIP_LOCATION.get(), x + 34, y, 0, 0.0f, 24.0f, 16, 10, 30, 34);
            int i = 0;
            for (Item item : ConfigSettings.SOULSPRING_LAMP_FUEL.get().keySet()) {
                for (FuelData fuelData : ConfigSettings.SOULSPRING_LAMP_FUEL.get().get((Object)item)) {
                    CompoundTag nbt = fuelData.item().flatMap(req -> req.nbt().tag(), CompoundTag::m_128391_, (a, b) -> {}).orElse(new CompoundTag());
                    graphics.m_280480_(new ItemStack((ItemLike)item, 1, nbt), x + i * 16 % 96, y + 12 + CSMath.floor((double)i / 6.0) * 16);
                    ++i;
                }
            }
        }
    }
}

