/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SoulSpringLampRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final ResourceLocation TEXTURE_FRAME = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_frame.png");
    public static final ResourceLocation TEXTURE_0 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_0.png");
    public static final ResourceLocation TEXTURE_1 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_1.png");
    public static final ResourceLocation TEXTURE_2 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_2.png");
    public static final ResourceLocation TEXTURE_3 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_3.png");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("cold_sweat", "soulspring_lamp"), "main");
    private static float TIME = 0.0f;
    private final ModelPart base;
    private final ModelPart heart;

    public SoulSpringLampRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSel) {
        super(dispatcher, modelSel);
        ModelPart root = modelSel.m_171103_(LAYER_LOCATION);
        this.base = root.m_171324_("base");
        this.heart = root.m_171324_("heart");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition base = partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-12.0f, -17.0f, 4.0f, 8.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(22, 21).m_171488_(-13.0f, -6.0f, 3.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(58, 21).m_171488_(-9.5f, -5.0f, 8.0f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(52, 18).m_171488_(-8.0f, -5.0f, 6.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-13.0f, -19.0f, 3.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(40, 13).m_171488_(-11.0f, -21.0f, 5.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, -7).m_171488_(-8.0f, -28.0f, 4.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition heart = partdefinition.m_171599_("heart", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (stack.m_150930_(ModItems.SOULSPRING_LAMP)) {
            Minecraft mc = Minecraft.m_91087_();
            boolean isFirstPerson = mc.f_91066_.m_92176_().m_90612_();
            double fuel = SoulspringLampItem.getFuel(stack);
            ResourceLocation texture = SoulSpringLampRenderer.getTexture(stack);
            if (fuel > 0.0) {
                this.heart.f_104201_ = -14.0f + (float)Math.sin(TIME / 8.0f) * 1.2f;
                this.heart.f_104203_ = CSMath.toRadians(TIME * 2.0f % 360.0f);
                this.heart.f_104204_ = CSMath.toRadians((TIME * 2.0f + 10.0f) % 360.0f);
                this.heart.f_104205_ = CSMath.toRadians(((double)TIME * 0.5 + 5.0) % 360.0);
            } else {
                this.heart.f_104201_ = -14.0f;
                this.heart.f_104204_ = 0.0f;
                this.heart.f_104203_ = 0.0f;
                this.heart.f_104205_ = 0.0f;
            }
            float emission = SoulspringLampItem.isLit(stack) ? (float)CSMath.blend(0.0, 1.0, fuel, 0.0, 64.0) : 0.0f;
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            VertexConsumer frameVertexes = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_FRAME));
            this.base.m_104301_(poseStack, frameVertexes, light, overlay);
            poseStack.m_85836_();
            double heartYOffset = isFirstPerson ? 1.65 : 1.55;
            float heartScale = isFirstPerson ? 0.925f : 0.9f;
            poseStack.m_85837_(0.0, heartYOffset, 0.0);
            poseStack.m_85841_(heartScale, heartScale, heartScale);
            VertexConsumer heartVtx = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            this.heart.m_104306_(poseStack, heartVtx, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f - emission);
            VertexConsumer heartVtxEmissive = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)texture));
            this.heart.m_104306_(poseStack, heartVtxEmissive, light, overlay, 1.0f, 1.0f, 1.0f, emission);
            poseStack.m_85849_();
            VertexConsumer glassVtx = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            this.base.m_104306_(poseStack, glassVtx, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f - emission);
            VertexConsumer glassVtxEmissive = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)texture));
            this.base.m_104306_(poseStack, glassVtxEmissive, light, overlay, 1.0f, 1.0f, 1.0f, emission);
            poseStack.m_85849_();
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            super.m_108829_(stack, displayContext, poseStack, buffer, light, overlay);
        }
    }

    private static ResourceLocation getTexture(ItemStack lamp) {
        double fuel = SoulspringLampItem.getFuel(lamp);
        CompoundTag tag = lamp.m_41784_();
        int state = tag.m_128471_("Lit") ? (fuel > 43.0 ? 3 : (fuel > 22.0 ? 2 : 1)) : 0;
        return switch (state) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            default -> TEXTURE_0;
        };
    }

    @SubscribeEvent
    public static void tickTimer(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91104_() && event.phase == TickEvent.Phase.START) {
            TIME += mc.m_91297_();
        }
    }
}

