/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.block.SmokestackBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class IceboxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty FROSTED = HearthBottomBlock.FROSTED;
    public static final BooleanProperty SMOKESTACK = BooleanProperty.m_61465_((String)"smokestack");
    public static final VoxelShape SHAPE = Shapes.m_83144_();
    private static final VoxelShape SHAPE_OPEN = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)1.0);

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f).m_60924_(IceboxBlock::conductsRedstone).m_60955_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties();
    }

    private static boolean conductsRedstone(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof HearthBlockEntity) {
            HearthBlockEntity hearthLike = (HearthBlockEntity)be;
            return !hearthLike.hasSmokestack();
        }
        return false;
    }

    public IceboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FROSTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SMOKESTACK, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.ICEBOX ? IceboxBlockEntity::tick : null;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext selection) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            return icebox.m_6683_(0.0f) > 0.0f ? SHAPE_OPEN : SHAPE;
        }
        return SHAPE;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity blockentity = level.m_7702_(pos);
        return blockentity != null && blockentity.m_7531_(id, param);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == ModItems.SMOKESTACK && rayTraceResult.m_82434_() == Direction.UP && level.m_8055_(pos.m_7494_()).m_247087_()) {
                return InteractionResult.FAIL;
            }
            int itemFuel = icebox.getItemFuel(stack);
            if (itemFuel != 0 && (double)icebox.getFuel() + (double)itemFuel * 0.75 < (double)icebox.getMaxFuel()) {
                if (!player.m_7500_()) {
                    if (stack.hasCraftingRemainingItem()) {
                        ItemStack container = stack.getCraftingRemainingItem();
                        stack.m_41774_(1);
                        player.m_150109_().m_36054_(container);
                    } else {
                        stack.m_41774_(1);
                    }
                }
                icebox.setFuel(icebox.getFuel() + itemFuel);
                level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else if (!level.f_46443_ && !ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)icebox, (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IceboxBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean hasSmokeStack;
        IceboxBlockEntity icebox;
        boolean hadSmokestack;
        BlockEntity blockEntity;
        if (neighborPos.equals((Object)pos.m_7494_()) && (blockEntity = level.m_7702_(pos)) instanceof IceboxBlockEntity && (hadSmokestack = (icebox = (IceboxBlockEntity)blockEntity).hasSmokestack()) != (hasSmokeStack = icebox.checkForSmokestack())) {
            state = (BlockState)state.m_61124_((Property)SMOKESTACK, (Comparable)Boolean.valueOf(hasSmokeStack));
            level.m_7731_(pos, state, 3);
            level.m_6289_(pos, (Block)this);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, neighborBlock, fromPos, isMoving);
        HearthBlockEntity hearth = (HearthBlockEntity)level.m_7702_(pos);
        if (hearth != null) {
            hearth.checkInputSignal();
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (state.m_60734_() != newState.m_60734_() && (tileentity = world.m_7702_(pos)) instanceof IceboxBlockEntity) {
            IceboxBlockEntity te = (IceboxBlockEntity)tileentity;
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)te);
            world.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FROSTED, SMOKESTACK});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        boolean belowSmokestack = context.m_43725_().m_8055_(pos.m_7494_()).m_60734_() instanceof SmokestackBlock;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)SMOKESTACK, (Comparable)Boolean.valueOf(belowSmokestack));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        ParticleStatus status = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_();
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        IceboxBlockEntity icebox = (IceboxBlockEntity)level.m_7702_(pos);
        if (icebox != null && icebox.isUsingColdFuel()) {
            IceboxBlock.createMistParticles(level, pos);
        }
    }

    public static void createMistParticles(Level level, BlockPos pos) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = pos.m_123342_();
        double d2 = (double)pos.m_123343_() + 0.5;
        boolean side = new Random().nextBoolean();
        double d5 = side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        double d6 = Math.random() * 0.3;
        double d7 = !side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        level.m_7106_((ParticleOptions)ParticleTypesInit.GROUND_MIST.get(), d0 + d5, d1 + d6, d2 + d7, d5 / 40.0, 0.0, d7 / 40.0);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.m_122434_() != Direction.Axis.Y && level.m_8055_(pos.m_7494_()).m_60713_(ModBlocks.SMOKESTACK);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }
}

