/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncConfigSettingsMessage {
    CompoundTag configValues;
    UUID menuOpener;

    public SyncConfigSettingsMessage(RegistryAccess registryAccess) {
        this(null, registryAccess);
    }

    public SyncConfigSettingsMessage(UUID menuOpener, RegistryAccess registryAccess) {
        this(ConfigSettings.encode(registryAccess), menuOpener);
    }

    private SyncConfigSettingsMessage(CompoundTag values, UUID menuOpener) {
        this.configValues = values;
        this.menuOpener = menuOpener;
    }

    public static void encode(SyncConfigSettingsMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.configValues);
        buffer.m_236835_(Optional.ofNullable(message.menuOpener), FriendlyByteBuf::m_130077_);
    }

    public static SyncConfigSettingsMessage decode(FriendlyByteBuf buffer) {
        return new SyncConfigSettingsMessage(buffer.m_130260_(), buffer.m_236860_(FriendlyByteBuf::m_130259_).orElse(null));
    }

    public static void handle(SyncConfigSettingsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
            if (context.getDirection().getReceptionSide().isServer()) {
                if (context.getSender() != null && context.getSender().m_20310_(2)) {
                    ConfigSettings.decode(message.configValues);
                    ConfigSettings.saveValues(registryAccess);
                    MainSettingsConfig.save();
                    WorldSettingsConfig.save();
                    ItemSettingsConfig.save();
                    EntitySettingsConfig.save();
                    ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncConfigSettingsMessage(null, registryAccess));
                }
            } else if (context.getDirection().getReceptionSide().isClient()) {
                try {
                    ConfigSettings.decode(message.configValues);
                }
                catch (Exception e) {
                    ColdSweat.LOGGER.error("Failed to decode config settings from server: ", (Throwable)e);
                }
                if (message.menuOpener != null && message.menuOpener.equals(ClientOnlyHelper.getClientPlayer().m_20148_())) {
                    ClientOnlyHelper.openConfigScreen();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

