/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public record EquipmentRequirement(ItemRequirement head, ItemRequirement chest, ItemRequirement legs, ItemRequirement feet, ItemRequirement mainHand, ItemRequirement offHand) {
    public static final Codec<EquipmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRequirement.CODEC.optionalFieldOf("head", (Object)ItemRequirement.NONE).forGetter(requirement -> requirement.head), (App)ItemRequirement.CODEC.optionalFieldOf("chest", (Object)ItemRequirement.NONE).forGetter(requirement -> requirement.chest), (App)ItemRequirement.CODEC.optionalFieldOf("legs", (Object)ItemRequirement.NONE).forGetter(requirement -> requirement.legs), (App)ItemRequirement.CODEC.optionalFieldOf("feet", (Object)ItemRequirement.NONE).forGetter(requirement -> requirement.feet), (App)ItemRequirement.CODEC.optionalFieldOf("mainhand", (Object)ItemRequirement.NONE).forGetter(requirement -> requirement.mainHand), (App)ItemRequirement.CODEC.optionalFieldOf("offhand", (Object)ItemRequirement.NONE).forGetter(requirement -> requirement.offHand)).apply((Applicative)instance, EquipmentRequirement::new));
    public static final EquipmentRequirement NONE = new EquipmentRequirement(ItemRequirement.NONE, ItemRequirement.NONE, ItemRequirement.NONE, ItemRequirement.NONE, ItemRequirement.NONE, ItemRequirement.NONE);

    public boolean test(Entity entity) {
        LivingEntity living;
        return this.equals(NONE) || entity instanceof LivingEntity && this.testSlot(EquipmentSlot.HEAD, living = (LivingEntity)entity) && this.testSlot(EquipmentSlot.CHEST, living) && this.testSlot(EquipmentSlot.LEGS, living) && this.testSlot(EquipmentSlot.FEET, living) && this.testSlot(EquipmentSlot.MAINHAND, living) && this.testSlot(EquipmentSlot.OFFHAND, living);
    }

    private boolean testSlot(EquipmentSlot slot, LivingEntity entity) {
        ItemRequirement requirement = switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.HEAD -> this.head;
            case EquipmentSlot.CHEST -> this.chest;
            case EquipmentSlot.LEGS -> this.legs;
            case EquipmentSlot.FEET -> this.feet;
            case EquipmentSlot.MAINHAND -> this.mainHand;
            case EquipmentSlot.OFFHAND -> this.offHand;
        };
        return requirement.test(entity.m_6844_(slot), true);
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EquipmentRequirement that = (EquipmentRequirement)obj;
        return this.head.equals(that.head) && this.chest.equals(that.chest) && this.legs.equals(that.legs) && this.feet.equals(that.feet) && this.mainHand.equals(that.mainHand) && this.offHand.equals(that.offHand);
    }
}

