/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;

public record FluidRequirement(NegatableList<Either<TagKey<Fluid>, Fluid>> fluids, BlockRequirement.StateRequirement state, Optional<Boolean> isSource) {
    public static final FluidRequirement NONE = new FluidRequirement(new NegatableList<Either<TagKey<Fluid>, Fluid>>(), BlockRequirement.StateRequirement.NONE, Optional.empty());
    public static final Codec<FluidRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrBuiltinCodec(Registries.f_256808_, ForgeRegistries.FLUIDS)).optionalFieldOf("fluids", new NegatableList()).forGetter(FluidRequirement::fluids), (App)BlockRequirement.StateRequirement.CODEC.optionalFieldOf("state", (Object)BlockRequirement.StateRequirement.NONE).forGetter(FluidRequirement::state), (App)Codec.BOOL.optionalFieldOf("is_source").forGetter(FluidRequirement::isSource)).apply((Applicative)instance, FluidRequirement::new));

    public boolean test(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_46749_(pPos)) {
            return true;
        }
        FluidState lState = pLevel.m_6425_(pPos);
        return this.test(lState);
    }

    public boolean test(FluidState state) {
        if (!this.fluids.test((T either) -> (Boolean)either.map(arg_0 -> ((FluidState)state).m_205070_(arg_0), arg_0 -> ((FluidState)state).m_192917_(arg_0)))) {
            return false;
        }
        if (this.isSource.isPresent() && this.isSource.get().booleanValue() != state.m_76170_()) {
            return false;
        }
        return this.state.test(state);
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FluidRequirement that = (FluidRequirement)obj;
        return this.fluids.equals(that.fluids) && this.state.equals(that.state);
    }
}

