/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Map;
import java.util.function.Supplier;

public record WorldTempRequirement(Either<Double, String> temperature) {
    public static final WorldTempRequirement INFINITY = new WorldTempRequirement(Double.POSITIVE_INFINITY);
    public static final WorldTempRequirement NEGATIVE_INFINITY = new WorldTempRequirement(Double.NEGATIVE_INFINITY);
    public static final Map<String, Supplier<Double>> VARIABLES = Map.of("temperate", () -> CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get()), "warm", () -> CSMath.blend(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get(), 0.67, 0.0, 1.0), "hot", () -> CSMath.blend(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get(), 0.83, 0.0, 1.0), "burning", () -> ConfigSettings.MAX_TEMP.get(), "cool", () -> CSMath.blend(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get(), 0.33, 0.0, 1.0), "cold", () -> CSMath.blend(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get(), 0.17, 0.0, 1.0), "freezing", () -> ConfigSettings.MAX_TEMP.get());
    public static final Codec<WorldTempRequirement> CODEC = Codec.either((Codec)Codec.DOUBLE, (Codec)Codec.STRING).xmap(either -> {
        if (either.right().isPresent() && !VARIABLES.containsKey(either.right().get())) {
            throw new IllegalArgumentException("Unknown temperature variable: " + (String)either.right().get());
        }
        return new WorldTempRequirement((Either<Double, String>)either);
    }, WorldTempRequirement::temperature);

    public WorldTempRequirement(double temperature) {
        this((Either<Double, String>)Either.left((Object)temperature));
    }

    public WorldTempRequirement(String temperature) {
        this((Either<Double, String>)Either.right((Object)temperature));
    }

    public double get() {
        if (this.temperature.left().isPresent()) {
            return (Double)this.temperature.left().get();
        }
        return VARIABLES.get(this.temperature.right().get()).get();
    }

    public boolean isConstant() {
        return this.temperature.left().isPresent();
    }
}

