/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.spec.CSConfigSpec;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.util.TriConsumer;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> NegatableList<Either<TagKey<T>, OptionalHolder<T>>> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String objects) {
        return ConfigHelper.parseRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> NegatableList<Either<TagKey<T>, OptionalHolder<T>>> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String[] objects) {
        NegatableList<Either<TagKey<Either>, OptionalHolder<Either>>> registryList = new NegatableList<Either<TagKey<Either>, OptionalHolder<Either>>>();
        Registry reg = registryAccess.m_175515_(registry);
        for (String objString : objects) {
            boolean negate = objString.startsWith("!");
            if (negate) {
                objString = objString.substring(1);
            }
            if (objString.startsWith("#")) {
                String tagString = objString.replace("#", "");
                ResourceLocation tagID = ResourceLocation.m_135820_((String)tagString);
                if (tagID == null) {
                    ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" is not a valid tag ID", (Object)registry.m_135782_().m_135815_(), (Object)tagString);
                    continue;
                }
                registryList.add(Either.left((Object)TagKey.m_203882_(registry, (ResourceLocation)tagID)), negate);
                continue;
            }
            ResourceLocation id = ResourceLocation.m_135820_((String)objString);
            if (id == null) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" is not a valid ID", (Object)registry.m_135782_().m_135815_(), (Object)objString);
                continue;
            }
            Optional obj = reg.m_203636_(ResourceKey.m_135785_(registry, (ResourceLocation)id));
            if (!reg.m_7804_(id) || obj.isEmpty()) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registry.m_135782_().m_135815_(), (Object)objString);
                continue;
            }
            registryList.add(Either.right(OptionalHolder.ofHolder((Holder)obj.get())), negate);
        }
        return registryList;
    }

    public static <T> NegatableList<Either<TagKey<T>, T>> parseBuiltinItems(ResourceKey<Registry<T>> registryKey, IForgeRegistry<T> registry, String objects) {
        return ConfigHelper.parseBuiltinItems(registryKey, registry, objects.split(","));
    }

    public static <T> NegatableList<Either<TagKey<T>, T>> parseBuiltinItems(ResourceKey<Registry<T>> registryKey, IForgeRegistry<T> registry, String[] objects) {
        NegatableList<Either<TagKey<Either>, Either>> registryList = new NegatableList<Either<TagKey<Either>, Either>>();
        for (String objString : objects) {
            boolean negate = objString.startsWith("!");
            if (negate) {
                objString = objString.substring(1);
            }
            if (objString.startsWith("#")) {
                String tagString = objString.replace("#", "");
                ResourceLocation tagID = ResourceLocation.m_135820_((String)tagString);
                if (tagID == null) {
                    ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" is not a valid tag ID", (Object)registryKey.m_135782_().m_135815_(), (Object)tagString);
                    continue;
                }
                registryList.add(Either.left((Object)TagKey.m_203882_(registryKey, (ResourceLocation)tagID)), negate);
                continue;
            }
            ResourceLocation id = ResourceLocation.m_135820_((String)objString);
            if (id == null) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" is not a valid ID", (Object)registryKey.m_135782_().m_135815_(), (Object)objString);
                continue;
            }
            if (!registry.containsKey(id)) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registryKey.m_135782_().m_135815_(), (Object)objString);
                continue;
            }
            Object obj = registry.getValue(id);
            registryList.add(Either.right((Object)obj), negate);
        }
        return registryList;
    }

    public static NegatableList<Either<TagKey<Block>, Block>> getBlocks(String blocks) {
        return ConfigHelper.getBlocks(blocks.split(","));
    }

    public static NegatableList<Either<TagKey<Block>, Block>> getBlocks(String[] blocks) {
        return ConfigHelper.parseBuiltinItems(Registries.f_256747_, ForgeRegistries.BLOCKS, blocks);
    }

    public static NegatableList<Either<TagKey<Item>, Item>> getItems(String items) {
        return ConfigHelper.getItems(items.split(","));
    }

    public static NegatableList<Either<TagKey<Item>, Item>> getItems(String[] items) {
        return ConfigHelper.parseBuiltinItems(Registries.f_256913_, ForgeRegistries.ITEMS, items);
    }

    public static NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> getEntityTypes(String entities) {
        return ConfigHelper.getEntityTypes(entities.split(","));
    }

    public static NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> getEntityTypes(String[] entities) {
        return ConfigHelper.parseBuiltinItems(Registries.f_256939_, ForgeRegistries.ENTITY_TYPES, entities);
    }

    public static <K, V extends ConfigData> Multimap<K, V> parseTomlRegistry(CSConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, NegatableList<Either<TagKey<K>, K>>> keyListGetter, IForgeRegistry<K> keyRegistry, RegistryHolder<V> valueRegistry) {
        RegistryMultiMap dataMap = new RegistryMultiMap();
        for (List<?> entry : config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setConfigType(ConfigData.Type.TOML);
            RegistryHelper.mapForgeRegistryTagList(keyRegistry, keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.removeEntries(dataMap.values(), valueRegistry);
        return dataMap;
    }

    public static <K, V extends ConfigData> Map<K, V> parseTomlRegistryUnique(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, List<Either<TagKey<K>, K>>> keyListGetter, IForgeRegistry<K> keyRegistry, RegistryHolder<V> valueRegistry) {
        HashMap dataMap = new HashMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setConfigType(ConfigData.Type.TOML);
            RegistryHelper.mapForgeRegistryTagList(keyRegistry, keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.removeEntries(dataMap.values(), valueRegistry);
        return dataMap;
    }

    private static <K, V> void putRegistryEntries(Multimap<K, V> map, IForgeRegistry<K> registry, List<Either<TagKey<K>, K>> list, V data) {
        RegistryHelper.mapForgeRegistryTagList(registry, list).forEach(entry -> map.put(entry, data));
    }

    public static <K, V extends ConfigData> Map<Holder<K>, V> getRegistryMap(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<Either<TagKey<K>, OptionalHolder<K>>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, registryAccess, keyRegistry, valueCreator, taggedListGetter, FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Multimap<Holder<K>, V> getRegistryMultimap(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<Either<TagKey<K>, OptionalHolder<K>>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, registryAccess, keyRegistry, valueCreator, taggedListGetter, FastMultiMap::new, FastMultiMap::put);
    }

    private static <K, V extends ConfigData, M> M getRegistryMapLike(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<Either<TagKey<K>, OptionalHolder<K>>>> taggedListGetter, Supplier<M> mapSupplier, TriConsumer<M, Holder<K>, V> mapAdder) {
        M map = mapSupplier.get();
        for (List<?> entry : source) {
            ConfigData data = (ConfigData)valueCreator.apply(entry);
            if (data != null) {
                data.setConfigType(ConfigData.Type.TOML);
                for (OptionalHolder<K> key : RegistryHelper.mapVanillaRegistryTagList(keyRegistry, taggedListGetter.apply(data), registryAccess)) {
                    mapAdder.accept(map, key.get(), (Object)data);
                }
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing {} config \"{}\"", (Object)keyRegistry.m_135782_(), (Object)entry.toString());
        }
        return map;
    }

    public static <T> Codec<Either<TagKey<T>, T>> tagOrBuiltinCodec(ResourceKey<Registry<T>> vanillaRegistry, IForgeRegistry<T> forgeRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> "Not a tag key: " + str);
            }
            ResourceLocation itemLocation = ResourceLocation.m_135820_((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.m_203882_((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + key.f_203868_()), (Codec)forgeRegistry.getCodec());
    }

    public static <T> Codec<Either<TagKey<T>, OptionalHolder<T>>> tagOrHolderCodec(final ResourceKey<Registry<T>> vanillaRegistry) {
        return new Codec<Either<TagKey<T>, OptionalHolder<T>>>(){

            public <S> DataResult<Pair<Either<TagKey<T>, OptionalHolder<T>>, S>> decode(DynamicOps<S> ops, S input) {
                DataResult result = Codec.STRING.parse(ops, input);
                if (result.error().isPresent()) {
                    return DataResult.error(() -> ((DataResult.PartialResult)result.error().get()).message());
                }
                String str = result.result().orElse("");
                if (str.startsWith("#")) {
                    ResourceLocation tagID = ResourceLocation.m_135820_((String)str.replace("#", ""));
                    if (tagID == null) {
                        return DataResult.error(() -> String.format("Invalid tag ID \"%s\"", str));
                    }
                    return DataResult.success((Object)Pair.of((Object)Either.left((Object)TagKey.m_203882_((ResourceKey)vanillaRegistry, (ResourceLocation)tagID)), input));
                }
                ResourceLocation objectID = ResourceLocation.m_135820_((String)str);
                if (objectID == null) {
                    return DataResult.error(() -> String.format("Invalid ID \"%s\"", str));
                }
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)vanillaRegistry, (ResourceLocation)objectID);
                return DataResult.success((Object)Pair.of((Object)Either.right(new OptionalHolder(key)), input));
            }

            public <S> DataResult<S> encode(Either<TagKey<T>, OptionalHolder<T>> either, DynamicOps<S> ops, S prefix) {
                if (either.left().isPresent()) {
                    return Codec.STRING.encode((Object)("#" + ((TagKey)either.left().get()).f_203868_()), ops, prefix);
                }
                if (either.right().isPresent()) {
                    OptionalHolder holder = (OptionalHolder)either.right().get();
                    ResourceKey key = holder.key();
                    return Codec.STRING.encode((Object)key.m_135782_().toString(), ops, prefix);
                }
                return DataResult.error(() -> "Either is empty");
            }
        };
    }

    public static <T> Codec<Either<TagKey<T>, ResourceKey<T>>> tagOrResourceKeyCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> "Not a tag key: " + str);
            }
            ResourceLocation itemLocation = ResourceLocation.m_135820_((String)str.replace("#", ""));
            if (itemLocation == null) {
                return DataResult.error(() -> String.format("Invalid tag ID \"%s\"", str));
            }
            return DataResult.success((Object)TagKey.m_203882_((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + key.f_203868_()), (Codec)ResourceKey.m_195966_(vanillaRegistry));
    }

    public static Optional<FuelData> findFirstFuelMatching(DynamicHolder<Multimap<Item, FuelData>> predicates, ItemStack stack) {
        for (FuelData predicate : predicates.get().get((Object)stack.m_41720_())) {
            if (!predicate.test(stack)) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> parseResource(ResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        Optional optional;
        if (resourceManager == null) {
            return Optional.empty();
        }
        Resource resource = (Resource)resourceManager.m_213713_(location).orElseThrow();
        InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);
        try {
            JsonObject json = GsonHelper.m_13859_((Reader)reader);
            optional = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ColdSweat.LOGGER.error((Object)new RuntimeException("Failed to load JSON file: " + location, e));
                return Optional.empty();
            }
        }
        ((Reader)reader).close();
        return optional;
    }

    public static String concatStringList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static <K, T extends ConfigData> List<T> getTaggedConfigsFor(K object, TagKey<T> tag, Multimap<K, T> config, RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(tag.f_203867_());
        ArrayList results = new ArrayList();
        for (ConfigData configData : config.get(object)) {
            Optional.ofNullable(configData.registryKey()).flatMap(k -> registry.m_203636_(k)).ifPresent(holder -> {
                if (holder.m_203656_(tag)) {
                    results.add(configData);
                }
            });
        }
        return results;
    }

    public static <K, V> V getFirstOrNull(DynamicHolder<Multimap<K, V>> map, K key, Predicate<V> filter) {
        List values = map.get().get(key).stream().filter(filter).toList();
        if (values.isEmpty()) {
            return null;
        }
        return (V)values.iterator().next();
    }
}

