package com.momosoftworks.coldsweat.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD, value = Dist.CLIENT)
public class ParticleUtil
{
    public static ParticleRenderType PARTICLE_SHEET_TRANSPARENT = new ParticleRenderType()
    {
        public void begin(BufferBuilder builder, TextureManager textureManager)
        {   RenderSystem.depthMask(true);
            RenderSystem.setShaderTexture(0, TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public void end(Tesselator tesselator)
        {   tesselator.end();
        }

        public String toString()
        {   return "PARTICLE_SHEET_TRANSPARENT";
        }
    };

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event)
    {   event.register(ParticleTypesInit.HEARTH_AIR.get(), HearthParticle.Factory::new);
        event.register(ParticleTypesInit.STEAM.get(), VaporParticle.SteamFactory::new);
        event.register(ParticleTypesInit.GROUND_MIST.get(), VaporParticle.GroundMistFactory::new);
        event.register(ParticleTypesInit.MIST.get(), VaporParticle.MistFactory::new);
        event.register(ParticleTypesInit.MOB_COLD.get(), EntityTempParticle.Factory::new);
        event.register(ParticleTypesInit.MOB_HOT.get(), EntityTempParticle.Factory::new);
    }
}
