/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntitiesTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity affectedEnt, Temperature.Trait trait) {
        Level level = affectedEnt.f_19853_;
        AABB aabb = new AABB(affectedEnt.m_20183_()).m_82386_(0.0, (double)(affectedEnt.m_20206_() / 2.0f) - 0.5, 0.0).m_82400_(16.0);
        List entities = affectedEnt.f_19853_.m_6249_((Entity)null, aabb, e -> true);
        if (entities.size() > 10) {
            entities = entities.subList(0, 10);
        }
        FastMap<EntityTempData, Double> effects = new FastMap<EntityTempData, Double>();
        double totalTemp = 0.0;
        for (Entity nearbyEnt : entities) {
            Collection entityTemps = ConfigSettings.ENTITY_TEMPERATURES.get().get((Object)nearbyEnt.m_6095_());
            for (EntityTempData tempData : entityTemps) {
                if (!tempData.test(nearbyEnt, (Entity)affectedEnt)) continue;
                double entityTemp = tempData.getTemperatureEffect(nearbyEnt, (Entity)affectedEnt);
                AtomicInteger blocksBetween = new AtomicInteger();
                WorldHelper.forBlocksInRay(EntityHelper.getCenterOf((Entity)affectedEnt), EntityHelper.getCenterOf(nearbyEnt), level, (state, pos) -> {
                    if (state.m_60804_((BlockGetter)level, pos)) {
                        blocksBetween.getAndIncrement();
                    }
                }, 3);
                entityTemp /= (double)(blocksBetween.get() + 1);
                double maxEffect = tempData.getMaxEffect();
                double currentTemp = effects.getOrDefault(tempData, 0.0);
                entityTemp = CSMath.clamp(entityTemp, -maxEffect - currentTemp, maxEffect - currentTemp);
                double maxTemp = tempData.getMaxTemp();
                double minTemp = tempData.getMinTemp();
                double newEffect = currentTemp + entityTemp;
                newEffect = CSMath.clamp(newEffect, minTemp, maxTemp);
                double effectDelta = newEffect - currentTemp;
                totalTemp += effectDelta;
                effects.put(tempData, newEffect);
            }
        }
        double finalTemp = totalTemp;
        return temp -> temp + finalTemp;
    }
}

